/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import io.meeds.social.observe.service.ObserverService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.ActivityCommentPlugin;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityCommentWatchPlugin
extends ActivityCommentPlugin {
    public static final String ID = "ActivityCommentWatchPlugin";
    private ObserverService observerService;
    private IdentityManager identityManager;
    private IdentityRegistry identityRegistry;
    private OrganizationService organizationService;

    public ActivityCommentWatchPlugin(ObserverService observerService, IdentityManager identityManager, IdentityRegistry identityRegistry, OrganizationService organizationService, InitParams initParams) {
        super(initParams);
        this.observerService = observerService;
        this.identityManager = identityManager;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NotificationInfo makeNotification(NotificationContext ctx) {
        HashSet<Long> receivers = new HashSet<Long>();
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        this.addWatchers(receivers, comment);
        this.addWatchers(receivers, activity);
        String poster = Utils.getUserId(comment.getUserId());
        HashSet<String> commentReceivers = new HashSet<String>();
        this.getNotificationReceivers(activity, comment, false).forEach(commentReceivers::add);
        if (StringUtils.isNotBlank((CharSequence)comment.getParentCommentId())) {
            this.getNotificationReceivers(activity, comment, true).forEach(commentReceivers::add);
        }
        commentReceivers.add(poster);
        List<String> receiversList = receivers.stream().map(this::getUsername).filter(u -> !commentReceivers.contains(u)).filter(username -> {
            Identity aclIdentity = this.getAclIdentity((String)username);
            return aclIdentity != null && Utils.getActivityManager().isActivityViewable(comment, aclIdentity);
        }).toList();
        if (receiversList.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(receiversList).setFrom(poster).setSpaceId(activity.getSpaceId() == null ? 0L : Long.parseLong(activity.getSpaceId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.COMMENT_ID.getKey(), comment.getId()).with(SocialNotificationUtils.POSTER.getKey(), poster).with(SocialNotificationUtils.WATCHED.getKey(), "true").key(this.getId());
    }

    private void addWatchers(Set<Long> receivers, ExoSocialActivity activity) {
        if (activity != null) {
            this.observerService.getObserverIdentityIds(activity.getMetadataObjectType(), activity.getMetadataObjectId()).forEach(receivers::add);
            this.observerService.getObserverIdentityIds("activity", activity.getId().replace("comment", "")).forEach(receivers::add);
        }
    }

    @Override
    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = Utils.getIdentityManager().getOrCreateSpaceIdentity(activity.getStreamOwner());
        return spaceIdentity == null || !activity.getPosterId().equals(spaceIdentity.getId());
    }

    private String getUsername(long identityId) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        return identity == null ? null : identity.getRemoteId();
    }

    private Identity getAclIdentity(String userId) {
        Identity aclIdentity = this.identityRegistry.getIdentity(userId);
        if (aclIdentity == null) {
            try {
                Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(userId);
                List<MembershipEntry> entries = memberships.stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
                aclIdentity = new Identity(userId, entries);
                this.identityRegistry.register(aclIdentity);
            }
            catch (Exception e) {
                return null;
            }
        }
        return aclIdentity;
    }
}

