/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.job;

import io.meeds.analytics.job.UsersStatisticsCountJob$AjcClosure1;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class UsersStatisticsCountJob {
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private IdentityManager identityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ContainerTransactional
    @Scheduled(initialDelay=2L, fixedDelay=180L, timeUnit=TimeUnit.MINUTES)
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        UsersStatisticsCountJob$AjcClosure1 usersStatisticsCountJob$AjcClosure1 = new UsersStatisticsCountJob$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(usersStatisticsCountJob$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void addUsersCountStatistic(String countType, int count, long startTime) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("account");
        statisticData.setOperation("usersCount");
        statisticData.setDuration(System.currentTimeMillis() - startTime);
        statisticData.addParameter("countType", (Object)countType);
        statisticData.addParameter("count", (Object)count);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    static {
        UsersStatisticsCountJob.ajc$preClinit();
    }

    static final /* synthetic */ void run_aroundBody0(UsersStatisticsCountJob ajc$this, JoinPoint joinPoint) {
        long startTime = System.currentTimeMillis();
        ListAccess allUsers = ajc$this.organizationService.getUserHandler().findAllUsers(UserStatus.ANY);
        int allUsersCount = allUsers.getSize();
        ListAccess enabledIdentities = ajc$this.identityManager.getIdentitiesByProfileFilter("organization", null, false);
        int enabledUsersCount = enabledIdentities.getSize();
        int disabledUsersCount = allUsersCount - enabledUsersCount;
        ajc$this.addUsersCountStatistic("allUsers", allUsersCount, startTime);
        ajc$this.addUsersCountStatistic("enabledUsers", enabledUsersCount, startTime);
        ajc$this.addUsersCountStatistic("disabledUsers", disabledUsersCount, startTime);
        startTime = System.currentTimeMillis();
        Group externalsGroup = ajc$this.organizationService.getGroupHandler().findGroupById("/platform/externals");
        int enabledExternalUsersCount = 0;
        if (externalsGroup != null) {
            ListAccess externalMemberships = ajc$this.organizationService.getMembershipHandler().findAllMembershipsByGroup(externalsGroup);
            enabledExternalUsersCount = externalMemberships.getSize();
        }
        ajc$this.addUsersCountStatistic("enabledExternalUsers", enabledExternalUsersCount, startTime);
        ajc$this.addUsersCountStatistic("enabledInternalUsers", enabledUsersCount - enabledExternalUsersCount, startTime);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UsersStatisticsCountJob.java", UsersStatisticsCountJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "io.meeds.analytics.job.UsersStatisticsCountJob", "", "", "", "void"), 62);
    }
}

