/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.function.Function;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilterBuilder;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class FetchSourceFilter
implements SourceFilter {
    @Nullable
    private final String[] includes;
    @Nullable
    private final String[] excludes;

    public static SourceFilter of(@Nullable String[] includes, @Nullable String[] excludes) {
        return new FetchSourceFilter(includes, excludes);
    }

    public static SourceFilter of(Function<FetchSourceFilterBuilder, FetchSourceFilterBuilder> builderFunction) {
        Assert.notNull(builderFunction, (String)"builderFunction must not be null");
        return builderFunction.apply(new FetchSourceFilterBuilder()).build();
    }

    public FetchSourceFilter(@Nullable String[] includes, @Nullable String[] excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }
}

