/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ThreadHelper {
    public static final String DEFAULT_PATTERN = "Social-Thread ##counter# - #name#";
    private static final Pattern INVALID_PATTERN = Pattern.compile(".*#\\w+#.*");
    private static AtomicLong threadCounter = new AtomicLong();

    private ThreadHelper() {
    }

    private static long nextThreadCounter() {
        return threadCounter.getAndIncrement();
    }

    public static String resolveThreadName(String pattern, String name) {
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        String longName = name;
        String shortName = name;
        shortName = Matcher.quoteReplacement(shortName);
        longName = Matcher.quoteReplacement(longName);
        String answer = pattern.replaceFirst("#counter#", "" + ThreadHelper.nextThreadCounter());
        answer = answer.replaceFirst("#longName#", longName);
        if (INVALID_PATTERN.matcher(answer = answer.replaceFirst("#name#", shortName)).matches()) {
            throw new IllegalArgumentException("Pattern is invalid: " + pattern);
        }
        return answer;
    }
}

