/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;

public class ServletContextDispatcher {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContainer servletContainer;

    public ServletContextDispatcher(HttpServletRequest request, HttpServletResponse response, ServletContainer servletContainer) {
        if (request == null) {
            throw new IllegalArgumentException("No null request allowed");
        }
        if (response == null) {
            throw new IllegalArgumentException("No null response allowed");
        }
        if (servletContainer == null) {
            throw new IllegalArgumentException("No null servlet container allowed");
        }
        this.request = request;
        this.response = response;
        this.servletContainer = servletContainer;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Object include(ServletContext targetServletContext, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        return this.servletContainer.include(targetServletContext, this.request, this.response, callback, handback);
    }
}

