/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.model.News;
import jakarta.annotation.PostConstruct;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsMetadataListener
extends Listener<String, News> {
    @Autowired
    private IndexingService indexingService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private TagService tagService;
    @Autowired
    private ListenerService listenerService;
    private String[] LISTENERS = new String[]{"exo.news.postArticle", "exo.news.updateArticle", "exo.news.shareArticle"};

    @PostConstruct
    public void init() {
        for (String listener : this.LISTENERS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, News> event) throws Exception {
        News news = (News)event.getData();
        String username = (String)event.getSource();
        this.saveTags(news, username);
        this.indexingService.reindex("news", news.getId());
    }

    private void saveTags(News news, String username) {
        long creatorId = this.getPosterId(username);
        long audienceId = this.getStreamOwnerId(news.getSpaceId(), username);
        Set tagNames = this.tagService.detectTagNames(news.getBody());
        this.tagService.saveTags(new TagObject("news", news.getId(), null), tagNames, audienceId, creatorId);
    }

    private long getStreamOwnerId(String spaceId, String username) {
        Space space = this.spaceService.getSpaceById(spaceId);
        return space == null ? this.getPosterId(username) : Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId());
    }

    private long getPosterId(String username) {
        return StringUtils.isBlank((CharSequence)username) ? 0L : Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
    }
}

