/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.storage;

import io.meeds.chat.dao.MatrixRoomDAO;
import io.meeds.chat.entity.RoomEntity;
import io.meeds.chat.model.Room;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixRoomStorage {
    private static final Log LOG = ExoLogger.getLogger(MatrixRoomStorage.class);
    @Autowired
    private MatrixRoomDAO matrixRoomDAO;
    @Autowired
    private SpaceService spaceService;

    public Room getMatrixRoomBySpaceId(String spaceId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findBySpaceId(spaceId);
        if (roomEntity != null) {
            return MatrixRoomStorage.toRoomModel(roomEntity);
        }
        LOG.warn("Can not find an associated matrix room for the space with ID {}", new Object[]{spaceId});
        return null;
    }

    public Space getSpaceIdByMatrixRoomId(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomId(roomId);
        if (roomEntity != null && StringUtils.isNotBlank((CharSequence)roomEntity.getSpaceId())) {
            return this.spaceService.getSpaceById(String.valueOf(roomEntity.getSpaceId()));
        }
        LOG.warn("Can not find an associated space for the matrix room with ID {}", new Object[]{roomId});
        return null;
    }

    public Room getDMRoomByRoomId(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomId(roomId);
        if (roomEntity != null && StringUtils.isNotBlank((CharSequence)roomEntity.getFirstParticipant()) && StringUtils.isNotBlank((CharSequence)roomEntity.getSecondParticipant())) {
            return MatrixRoomStorage.toRoomModel(roomEntity);
        }
        LOG.warn("Can not find an associated space for the matrix room with ID {}", new Object[]{roomId});
        return null;
    }

    public Room saveRoomForSpace(String spaceId, String roomId) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setSpaceId(spaceId);
        roomEntity.setRoomId(roomId);
        return MatrixRoomStorage.toRoomModel((RoomEntity)this.matrixRoomDAO.save(roomEntity));
    }

    public Room saveDirectMessagingRoom(String firstParticipantId, String secondParticipantId, String roomId) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setRoomId(roomId);
        roomEntity.setFirstParticipant(firstParticipantId);
        roomEntity.setSecondParticipant(secondParticipantId);
        return MatrixRoomStorage.toRoomModel((RoomEntity)this.matrixRoomDAO.save(roomEntity));
    }

    private static List<Room> toRoomList(List<RoomEntity> roomEntities) {
        ArrayList<Room> rooms = new ArrayList<Room>();
        for (RoomEntity roomEntity : roomEntities) {
            rooms.add(MatrixRoomStorage.toRoomModel(roomEntity));
        }
        return rooms;
    }

    public long getSpaceRoomCount() {
        return this.matrixRoomDAO.count();
    }

    public Room getDirectMessagingRoom(String firstParticipantId, String secondParticipantId) {
        RoomEntity directMessagingRoom = this.matrixRoomDAO.findByFirstParticipantAndSecondParticipant(firstParticipantId, secondParticipantId);
        if (directMessagingRoom != null) {
            return MatrixRoomStorage.toRoomModel(directMessagingRoom);
        }
        return null;
    }

    public List<Room> getMatrixDMRoomsOfUser(String user) {
        return this.toDirectMessagingRoomModelList(this.matrixRoomDAO.findByFirstParticipantOrSecondParticipant(user, user));
    }

    private List<Room> toDirectMessagingRoomModelList(List<RoomEntity> roomEntities) {
        return roomEntities.stream().map(MatrixRoomStorage::toRoomModel).toList();
    }

    public void removeMatrixRoom(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomId(roomId);
        this.matrixRoomDAO.delete(roomEntity);
    }

    public Room getById(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomIdStartsWith(roomId);
        if (roomEntity != null) {
            return MatrixRoomStorage.toRoomModel(roomEntity);
        }
        return null;
    }

    public static Room toRoomModel(RoomEntity roomEntity) {
        Room room = new Room();
        room.setId(roomEntity.getId());
        room.setRoomId(roomEntity.getRoomId());
        room.setSpaceId(roomEntity.getSpaceId());
        room.setFirstParticipant(roomEntity.getFirstParticipant());
        room.setSecondParticipant(roomEntity.getSecondParticipant());
        return room;
    }

    public List<Room> getSpaceRooms() {
        return MatrixRoomStorage.toRoomList(this.matrixRoomDAO.findBySpaceIdIsNotNull());
    }
}

