/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.listener;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.NavigationConfiguration;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NavigationConfigurationSiteDisplayListener
implements ListenerBase<NavigationConfiguration, NavigationConfiguration> {
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private LayoutService layoutService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("social.navigation.configuration.updated", (ListenerBase)this);
    }

    public void onEvent(Event<NavigationConfiguration, NavigationConfiguration> event) throws Exception {
        NavigationConfiguration oldConfiguration = (NavigationConfiguration)event.getSource();
        NavigationConfiguration newConfiguration = (NavigationConfiguration)event.getData();
        List oldSiteNames = oldConfiguration == null ? Collections.emptyList() : this.getSiteNames(oldConfiguration);
        List<String> newSiteNames = this.getSiteNames(newConfiguration);
        ArrayList<String> sitesWithoutSharedLayout = new ArrayList<String>(oldSiteNames);
        sitesWithoutSharedLayout.removeAll(newSiteNames);
        sitesWithoutSharedLayout.forEach(siteName -> {
            PortalConfig site = this.layoutService.getPortalConfig(SiteKey.portal((String)siteName));
            if (site != null) {
                site.setDisplayed(false);
                this.layoutService.save(site);
            }
        });
        newSiteNames.forEach(siteName -> {
            PortalConfig site = this.layoutService.getPortalConfig(SiteKey.portal((String)siteName));
            int displayOrder = newSiteNames.indexOf(siteName) + 1;
            if (!(site == null || site.isDisplayed() && site.getDisplayOrder() == displayOrder)) {
                site.setDisplayed(true);
                site.setDisplayOrder(displayOrder);
                this.layoutService.save(site);
            }
        });
    }

    private List<String> getSiteNames(NavigationConfiguration configuration) {
        return configuration.getSidebar().getItems().stream().filter(item -> item.getType() == SidebarItemType.SITE).map(item -> (String)item.getProperties().get("siteName")).toList();
    }
}

