/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.storage;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.ecs.storage.NoSuchObjectException;

public class Array
implements Enumeration,
Serializable {
    private int current = 0;
    private int size = 10;
    private int grow = 2;
    private int place = 0;
    private Object[] elements = null;
    private Object[] tmpElements = null;

    public Array() {
        this.init();
    }

    public Array(int n) {
        this.setSize(n);
        this.init();
    }

    public Array(int n, int n2) {
        this.setSize(n);
        this.setGrow(n2);
        this.init();
    }

    public void add(int n, Object object2) {
        try {
            this.elements[n] = object2;
        }
        catch (ArrayStoreException arrayStoreException) {}
    }

    public void add(Object object2) {
        if (this.current == this.elements.length) {
            this.grow();
        }
        try {
            this.elements[this.current] = object2;
            ++this.current;
        }
        catch (ArrayStoreException arrayStoreException) {}
    }

    public Enumeration elements() {
        return this;
    }

    public Object get(int n) {
        return this.elements[n];
    }

    public int getCurrentSize() {
        return this.current;
    }

    public void grow() {
        this.size = this.size += this.size / this.grow;
        this.rehash();
    }

    public boolean hasMoreElements() {
        return this.place < this.elements.length && this.current != this.place;
    }

    private void init() {
        this.elements = new Object[this.size];
    }

    public int location(Object object2) throws NoSuchObjectException {
        int n = -1;
        int n2 = 0;
        while (n2 < this.elements.length) {
            if (this.elements[n2] != null && this.elements[n2] == object2 || this.elements[n2] != null && this.elements[n2].equals(object2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new NoSuchObjectException();
        }
        return n;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.elements[this.place] != null && this.place != this.current) {
            ++this.place;
            return this.elements[this.place - 1];
        }
        this.place = 0;
        throw new NoSuchElementException();
    }

    public void rehash() {
        this.tmpElements = new Object[this.size];
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length) {
            if (this.elements[n2] != null) {
                this.tmpElements[n] = this.elements[n2];
                ++n;
            }
            ++n2;
        }
        this.elements = (Object[])this.tmpElements.clone();
        this.tmpElements = null;
        this.current = n;
    }

    public void remove(int n) {
        this.elements[n] = null;
    }

    public void setGrow(int n) {
        this.grow = n;
    }

    public void setSize(int n) {
        this.size = n;
    }
}

