/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.storage;

import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.client.WomClientService;
import io.meeds.wallet.service.WalletTokenAdminService;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomParsingException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.utils.JsonUtils;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HubIdentityStorage {
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private WomClientService womServiceClient;
    @Autowired
    private WalletTokenAdminService walletTokenAdminService;
    @Autowired
    private ListenerService listenerService;
    private boolean retrievedFromWom;
    private HubTenant hub = null;

    public HubTenant getHub() {
        return this.getHub(false);
    }

    public HubTenant getHub(boolean forceRefresh) {
        if (!forceRefresh && this.retrievedFromWom && (this.hub == null || !this.hub.isConnected() || this.hub.getUntilDate() == null || this.hub.getUntilDate().isAfter(Instant.now()))) {
            return this.hub;
        }
        Profile hubProfile = this.getHubProfile();
        if (forceRefresh || hubProfile.getProperty("HUB_NAME") != null) {
            this.hub = this.mapToHub(hubProfile);
            this.retrieveHubFromWoM(hubProfile, forceRefresh);
            HubTenant refreshedHub = this.mapToHub(hubProfile);
            if (refreshedHub.isConnected() && !this.hub.isConnected()) {
                this.listenerService.broadcast("deed.tenant.hub.connected", (Object)refreshedHub, (Object)this.hub);
            } else if (!refreshedHub.isConnected() && this.hub.isConnected()) {
                this.listenerService.broadcast("deed.tenant.hub.disconnected", (Object)this.hub, null);
            }
            this.hub = refreshedHub;
        } else {
            this.hub = this.mapToHub(hubProfile);
            this.retrievedFromWom = true;
        }
        return this.hub;
    }

    public String getHubAddress() {
        return (String)this.getHubProfile().getProperty("HUB_ADDRESS");
    }

    public String getHubWallet() {
        return (String)this.getHubProfile().getProperty("HUB_WALLET");
    }

    public void saveHubWallet(String address, String wallet) {
        Profile hubProfile = this.getHubProfile();
        hubProfile.setProperty("HUB_ADDRESS", (Object)StringUtils.lowerCase((String)address));
        hubProfile.setProperty("HUB_WALLET", (Object)wallet);
        this.identityManager.updateProfile(hubProfile);
    }

    public void saveHubConnectionResponse(WomConnectionResponse connectionResponse) {
        Profile hubProfile = this.getHubProfile();
        hubProfile.setProperty("WOM_CONTRACT_ADDRESS", (Object)connectionResponse.getWomAddress());
        hubProfile.setProperty("UEM_CONTRACT_ADDRESS", (Object)connectionResponse.getUemAddress());
        hubProfile.setProperty("WOM_NETWORK_ID", (Object)connectionResponse.getNetworkId());
        this.identityManager.updateProfile(hubProfile);
    }

    public void saveHubAvatarUpdateTime(long avatarUpdateTime) {
        Profile hubProfile = this.getHubProfile();
        hubProfile.setProperty("HUB_AVATAR_UPDATE_TIME", (Object)String.valueOf(avatarUpdateTime));
        this.identityManager.updateProfile(hubProfile);
    }

    public void refreshHubIdentity() {
        this.retrievedFromWom = false;
        this.hub = null;
    }

    private Profile getHubProfile() {
        return this.getHubIdentity().getProfile();
    }

    private Identity getHubIdentity() {
        return this.identityManager.getOrCreateIdentity("WALLET_HUB", "HUB");
    }

    private void retrieveHubFromWoM(Profile hubProfile, boolean forceRefresh) {
        try {
            String hubAddress = (String)hubProfile.getProperty("HUB_ADDRESS");
            Hub remoteHub = this.womServiceClient.getHub(hubAddress, forceRefresh);
            if (remoteHub == null) {
                this.clearHubProperties(hubProfile);
            } else {
                this.mapToProfile(hubProfile, remoteHub);
            }
            this.retrievedFromWom = true;
        }
        catch (WomException e) {
            throw new IllegalStateException("Error communicating with WoM Server, couldn't retrieve Hub remote status", e);
        }
    }

    private void mapToProfile(Profile hubProfile, Hub hub) throws WomParsingException {
        hubProfile.setProperty("DEED_ID", (Object)String.valueOf(hub.getDeedId()));
        hubProfile.setProperty("DEED_CITY", (Object)String.valueOf(hub.getCity()));
        hubProfile.setProperty("DEED_TYPE", (Object)String.valueOf(hub.getType()));
        hubProfile.setProperty("HUB_NAME", (Object)JsonUtils.toJsonString((Object)hub.getName()));
        hubProfile.setProperty("HUB_DESCRIPTION", (Object)JsonUtils.toJsonString((Object)hub.getDescription()));
        hubProfile.setProperty("HUB_URL", (Object)hub.getUrl());
        hubProfile.setProperty("HUB_PERIOD_TYPE", (Object)hub.getRewardsPeriodType());
        hubProfile.setProperty("HUB_REWARDS_AMOUNT", (Object)String.valueOf(hub.getRewardsPerPeriod()));
        hubProfile.setProperty("HUB_OWNER_CLAIMABLE_AMOUNT", (Object)String.valueOf(hub.getOwnerClaimableAmount()));
        hubProfile.setProperty("HUB_MANAGER_CLAIMABLE_AMOUNT", (Object)String.valueOf(hub.getManagerClaimableAmount()));
        hubProfile.setProperty("HUB_USERS_COUNT", (Object)String.valueOf(hub.getUsersCount()));
        hubProfile.setProperty("HUB_COLOR", (Object)hub.getColor());
        hubProfile.setProperty("HUB_OWNER_ADDRESS", (Object)hub.getHubOwnerAddress());
        hubProfile.setProperty("DEED_OWNER_ADDRESS", (Object)hub.getDeedOwnerAddress());
        hubProfile.setProperty("DEED_MANAGER_ADDRESS", (Object)hub.getDeedManagerAddress());
        hubProfile.setProperty("HUB_CREATED_DATE", (Object)String.valueOf(hub.getCreatedDate().toEpochMilli()));
        hubProfile.setProperty("HUB_UPDATED_DATE", (Object)String.valueOf(hub.getUpdatedDate().toEpochMilli()));
        if (hub.getJoinDate() == null) {
            hubProfile.removeProperty("HUB_START_JOIN_DATE");
        } else {
            hubProfile.setProperty("HUB_START_JOIN_DATE", (Object)String.valueOf(hub.getJoinDate().toEpochMilli()));
        }
        if (hub.getUntilDate() == null) {
            hubProfile.removeProperty("HUB_END_JOIN_DATE");
        } else {
            hubProfile.setProperty("HUB_END_JOIN_DATE", (Object)String.valueOf(hub.getUntilDate().toEpochMilli()));
        }
        hubProfile.setProperty("HUB_ENABLED", (Object)String.valueOf(hub.isConnected()));
        this.identityManager.updateProfile(hubProfile);
    }

    private HubTenant mapToHub(Profile hubProfile) {
        String deedId = (String)hubProfile.getProperty("DEED_ID");
        String city = (String)hubProfile.getProperty("DEED_CITY");
        String type = (String)hubProfile.getProperty("DEED_TYPE");
        String address = (String)hubProfile.getProperty("HUB_ADDRESS");
        String name = (String)hubProfile.getProperty("HUB_NAME");
        String description = (String)hubProfile.getProperty("HUB_DESCRIPTION");
        String url = (String)hubProfile.getProperty("HUB_URL");
        String rewardsAmount = (String)hubProfile.getProperty("HUB_REWARDS_AMOUNT");
        String rewardsPeriodType = (String)hubProfile.getProperty("HUB_PERIOD_TYPE");
        String usersCount = (String)hubProfile.getProperty("HUB_USERS_COUNT");
        String color = (String)hubProfile.getProperty("HUB_COLOR");
        String hubOwnerAddress = (String)hubProfile.getProperty("HUB_OWNER_ADDRESS");
        String deedOwnerAddress = (String)hubProfile.getProperty("DEED_OWNER_ADDRESS");
        String deedManagerAddress = (String)hubProfile.getProperty("DEED_MANAGER_ADDRESS");
        String womAddress = (String)hubProfile.getProperty("WOM_CONTRACT_ADDRESS");
        String uemAddress = (String)hubProfile.getProperty("UEM_CONTRACT_ADDRESS");
        String ownerClaimableAmount = (String)hubProfile.getProperty("HUB_OWNER_CLAIMABLE_AMOUNT");
        String managerClaimableAmount = (String)hubProfile.getProperty("HUB_MANAGER_CLAIMABLE_AMOUNT");
        long womNetworkId = this.parseLong((String)hubProfile.getProperty("WOM_NETWORK_ID"));
        Instant createdDate = this.parseInstant(hubProfile, "HUB_CREATED_DATE");
        Instant updatedDate = this.parseInstant(hubProfile, "HUB_UPDATED_DATE");
        Instant joinDate = this.parseInstant(hubProfile, "HUB_START_JOIN_DATE");
        Instant untilDate = this.parseInstant(hubProfile, "HUB_END_JOIN_DATE");
        boolean enabled = this.parseBoolean((String)hubProfile.getProperty("HUB_ENABLED"), false) && (untilDate == null || untilDate.isAfter(Instant.now()));
        long avatarUpdateTime = this.parseLong((String)hubProfile.getProperty("HUB_AVATAR_UPDATE_TIME"));
        return new HubTenant(this.parseLong(deedId), this.parseShort(city), this.parseShort(type), address, this.parseMap(name), this.parseMap(description), url, color, hubOwnerAddress, deedOwnerAddress, deedManagerAddress, createdDate, untilDate, joinDate, updatedDate, this.parseLong(usersCount), rewardsPeriodType, this.parseDouble(rewardsAmount), enabled, this.parseDouble(ownerClaimableAmount), this.parseDouble(managerClaimableAmount), this.womServiceClient.getWomUrl(), this.walletTokenAdminService.getAdminWalletAddress(), womAddress, uemAddress, womNetworkId, avatarUpdateTime);
    }

    private void clearHubProperties(Profile hubProfile) {
        if (hubProfile.getIdentity() != null && StringUtils.isNotBlank((CharSequence)hubProfile.getIdentity().getId())) {
            hubProfile.removeProperty("DEED_ID");
            hubProfile.removeProperty("DEED_CITY");
            hubProfile.removeProperty("DEED_TYPE");
            hubProfile.removeProperty("DEED_OWNER_ADDRESS");
            hubProfile.removeProperty("DEED_MANAGER_ADDRESS");
            hubProfile.removeProperty("HUB_END_JOIN_DATE");
            hubProfile.removeProperty("HUB_PERIOD_TYPE");
            hubProfile.removeProperty("HUB_REWARDS_AMOUNT");
            hubProfile.removeProperty("HUB_OWNER_CLAIMABLE_AMOUNT");
            hubProfile.removeProperty("HUB_MANAGER_CLAIMABLE_AMOUNT");
            hubProfile.removeProperty("HUB_USERS_COUNT");
            hubProfile.removeProperty("HUB_ENABLED");
            hubProfile.removeProperty("HUB_AVATAR_UPDATE_TIME");
            this.identityManager.updateProfile(hubProfile);
        }
    }

    private Map<String, String> parseMap(String value) {
        try {
            return StringUtils.isBlank((CharSequence)value) ? Collections.emptyMap() : (Map)JsonUtils.fromJsonString((String)value, Map.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error parsing value: " + value, e);
        }
    }

    private Instant parseInstant(Profile hubProfile, String propName) {
        String propDateMillis = (String)hubProfile.getProperty(propName);
        return StringUtils.isBlank((CharSequence)propDateMillis) ? null : Instant.ofEpochMilli(Long.parseLong(propDateMillis));
    }

    private double parseDouble(String value) {
        return StringUtils.isBlank((CharSequence)value) ? 0.0 : Double.parseDouble(value);
    }

    private long parseLong(String value) {
        return StringUtils.isBlank((CharSequence)value) ? 0L : Long.parseLong(value);
    }

    private short parseShort(String value) {
        return StringUtils.isBlank((CharSequence)value) ? (short)0 : Short.parseShort(value);
    }

    private boolean parseBoolean(String value, boolean defaulValue) {
        return StringUtils.isBlank((CharSequence)value) ? defaulValue : StringUtils.equals((CharSequence)value, (CharSequence)"true");
    }
}

