/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.storage;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.model.CategorySearchFilter;
import io.meeds.social.category.storage.elasticsearch.CategorySearchConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class CategoryStorage {
    private static final Log LOG = ExoLogger.getLogger(CategoryStorage.class);
    private static final String PROP_ACCESS_PERMISSIONS = "categoryAccessPermissions";
    private static final String PROP_LINK_PERMISSIONS = "categoryLinkPermissions";
    private static final String PROP_PARENT_ID = "categoryParentId";
    private static final String PROP_OWNER_ROOT_ID = "categoryOwnerRootId";
    private static final String PROP_ICON = "categoryIcon";
    private static final MetadataType METADATA_TYPE = new MetadataType(54175L, "category");
    @Autowired
    private CategorySearchConnector searchConnector;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private ListenerService listenerService;

    public Category createCategory(Category category) {
        Metadata metadata = this.toMetadata(category);
        metadata = this.metadataService.createMetadata(metadata, category.getCreatorId());
        Category createdCategory = this.toCategory(metadata);
        this.listenerService.broadcast("social.category.created", (Object)createdCategory, (Object)category.getCreatorId());
        return createdCategory;
    }

    @CacheEvict(cacheNames={"social.category"}, key="#root.args[0].getId()")
    public Category updateCategory(Category category) {
        Metadata metadata = this.toMetadata(category);
        metadata = this.metadataService.updateMetadata(metadata, category.getCreatorId());
        this.listenerService.broadcast("social.category.updated", (Object)category, (Object)category.getCreatorId());
        return this.toCategory(metadata);
    }

    @CacheEvict(cacheNames={"social.category"})
    public Category deleteCategory(long id) {
        Category category;
        List<Long> ids = this.getSubcategoryIds(id, 0L, -1L);
        if (CollectionUtils.isNotEmpty(ids)) {
            ids.forEach(this::deleteCategory);
        }
        if ((category = this.getCategory(id)) != null) {
            this.metadataService.deleteMetadataById(category.getId());
            this.listenerService.broadcast("social.category.deleted", (Object)category, (Object)category.getCreatorId());
        }
        return category;
    }

    @Cacheable(cacheNames={"social.category"})
    public Category getCategory(long categoryId) {
        Metadata metadata = this.metadataService.getMetadataById(categoryId);
        return this.toCategory(metadata);
    }

    @Cacheable(cacheNames={"social.categoryRootId"})
    public long getRootCategoryId(long ownerId) {
        List metadataIds = this.metadataService.getMetadataIdsByProperty(PROP_OWNER_ROOT_ID, String.valueOf(ownerId), 0L, 1L);
        return CollectionUtils.isEmpty((Collection)metadataIds) ? 0L : (Long)metadataIds.get(0);
    }

    public Category getRootCategory(long ownerId) {
        long rootId = this.getRootCategoryId(ownerId);
        return rootId == 0L ? null : this.getCategory(rootId);
    }

    public List<Long> getSubcategoryIds(long categoryId, long offset, long limit) {
        return this.metadataService.getMetadataIdsByProperty(PROP_PARENT_ID, String.valueOf(categoryId), offset, limit);
    }

    public long countSubcategories(long categoryId) {
        return this.metadataService.countMetadataIdsByProperty(PROP_PARENT_ID, String.valueOf(categoryId));
    }

    public List<Category> findCategories(CategorySearchFilter filter, List<Long> identityIds, Locale locale) {
        List<Long> ids = this.findCategoryIds(filter, identityIds, locale);
        return ids.stream().map(this::getCategory).toList();
    }

    public List<Long> findCategoryIds(CategorySearchFilter filter, List<Long> identityIds, Locale locale) {
        return this.searchConnector.search(filter, identityIds, locale);
    }

    public int countSubcategories(CategorySearchFilter filter, List<Long> identityIds, Locale locale) {
        return this.searchConnector.count(filter, identityIds, locale);
    }

    public List<Long> getLinkedIds(CategoryObject object) {
        List items = this.metadataService.getMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), (MetadataObject)object);
        return items == null ? Collections.emptyList() : items.stream().map(MetadataItem::getMetadata).map(Metadata::getId).toList();
    }

    public List<Long> getLinkedIds(String objectType) {
        List items = this.metadataService.getMetadataItemsByMetadataTypeAndObjectType(METADATA_TYPE.getName(), objectType);
        return items == null ? Collections.emptyList() : new ArrayList(items.stream().map(MetadataItem::getMetadata).map(Metadata::getId).collect(Collectors.toSet()));
    }

    public boolean isLinked(long categoryId, CategoryObject object) {
        return this.getMetadataItem(categoryId, object) != null;
    }

    public void link(long categoryId, CategoryObject object, long userIdentityId) {
        Metadata metadata = this.metadataService.getMetadataById(categoryId);
        this.metadataService.createMetadataItem((MetadataObject)object, metadata.key(), userIdentityId);
        this.listenerService.broadcast("social.category.object.linked", (Object)object, (Object)categoryId);
    }

    public void unlink(long categoryId, CategoryObject object) {
        MetadataItem metadataItem = this.getMetadataItem(categoryId, object);
        if (metadataItem != null) {
            try {
                this.metadataService.deleteMetadataItem(metadataItem.getId(), metadataItem.getCreatorId());
                this.listenerService.broadcast("social.category.object.unlinked", (Object)object, (Object)categoryId);
            }
            catch (ObjectNotFoundException e) {
                LOG.debug("Unable to link object {} to category {}", new Object[]{object, categoryId, e});
            }
        }
    }

    public MetadataItem getMetadataItem(long categoryId, CategoryObject object) {
        Metadata metadata = this.metadataService.getMetadataById(categoryId);
        if (metadata == null) {
            return null;
        }
        List items = this.metadataService.getMetadataItemsByMetadataAndObject(metadata.key(), (MetadataObject)object);
        return CollectionUtils.isNotEmpty((Collection)items) ? (MetadataItem)items.get(0) : null;
    }

    public List<Long> getAllCategoryIds(int offset, int limit) {
        return this.metadataService.getMetadataIds(METADATA_TYPE.getName(), offset, limit);
    }

    private Category toCategory(Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        Category category = new Category();
        category.setId(metadata.getId());
        category.setOwnerId(metadata.getAudienceId());
        category.setCreatorId(metadata.getCreatorId());
        category.setIcon((String)metadata.getProperties().get(PROP_ICON));
        category.setParentId(Long.parseLong((String)metadata.getProperties().get(PROP_PARENT_ID)));
        category.setAccessPermissionIds(this.toList((String)metadata.getProperties().get(PROP_ACCESS_PERMISSIONS)));
        category.setLinkPermissionIds(this.toList((String)metadata.getProperties().get(PROP_LINK_PERMISSIONS)));
        return category;
    }

    private Metadata toMetadata(Category category) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (category.getParentId() == 0L) {
            properties.put(PROP_OWNER_ROOT_ID, String.valueOf(category.getOwnerId()));
        }
        properties.put(PROP_PARENT_ID, String.valueOf(category.getParentId()));
        properties.put(PROP_LINK_PERMISSIONS, this.toString(category.getLinkPermissionIds()));
        properties.put(PROP_ACCESS_PERMISSIONS, this.toString(category.getAccessPermissionIds()));
        properties.put(PROP_ICON, category.getIcon());
        return new Metadata(category.getId(), METADATA_TYPE, UUID.randomUUID().toString(), category.getOwnerId(), category.getCreatorId(), System.currentTimeMillis(), properties);
    }

    private String toString(List<Long> ids) {
        return String.format("[%s]", ids == null ? "" : StringUtils.join(ids, (String)","));
    }

    private List<Long> toList(String ids) {
        return StringUtils.isBlank((CharSequence)ids) ? Collections.emptyList() : Arrays.asList(ids.substring(1, ids.length() - 1).split(",")).stream().filter(StringUtils::isNotBlank).map(Long::parseLong).toList();
    }
}

