/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.model.AvatarAttachment;

public class ImageUtils {
    public static final String KEY_SEPARATOR = "_";
    public static final String KEY_DIMENSION_SEPARATOR = "x";
    public static final String GIF_EXTENDSION = "gif";
    private static final int DEFAULT_AVATAR_WIDTH = 350;
    private static final int DEFAULT_AVATAR_HEIGHT = 350;
    private static final Log LOG = ExoLogger.getLogger(ImageUtils.class);

    private static void makeNotNull(String ... str) {
        for (String string : str) {
            if (string != null) continue;
            string = "";
        }
    }

    public static String buildFileName(String oldFileName, String subfix, String postfix) {
        ImageUtils.makeNotNull(oldFileName, subfix, postfix);
        if (oldFileName.equals("")) {
            return subfix + postfix;
        }
        int dotIndex = oldFileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return subfix + oldFileName + postfix;
        }
        String nameOnly = oldFileName.substring(0, dotIndex);
        String extendtionAndDot = oldFileName.substring(dotIndex);
        return subfix + nameOnly + postfix + extendtionAndDot;
    }

    public static String buildImagePostfix(int width, int height) {
        return KEY_SEPARATOR + (width < 0 ? 0 : width) + KEY_DIMENSION_SEPARATOR + (height < 0 ? 0 : height);
    }

    public static AvatarAttachment createResizedAvatarAttachment(InputStream imageStream, int maxWidth, int maxHeight, String avatarId, String avatarFileName, String avatarMimeType, String avatarWorkspace) {
        if (maxHeight <= 0 || maxWidth <= 0) {
            LOG.warn((Object)"Fail to resize image to avatar attachment with dimension <= 0");
            return null;
        }
        try {
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            String extension = mimeTypeResolver.getExtension(avatarMimeType);
            if (extension.equalsIgnoreCase(GIF_EXTENDSION)) {
                return null;
            }
            BufferedImage image = ImageIO.read(imageStream);
            int targetHeight = image.getHeight();
            int targetWidth = image.getWidth();
            double maxDimensionsRatio = (double)maxHeight / (double)maxWidth;
            double imageRatio = (double)image.getHeight() / (double)image.getWidth();
            if (imageRatio > maxDimensionsRatio && image.getHeight() > maxHeight) {
                targetHeight = maxHeight;
                targetWidth = maxHeight * image.getWidth() / image.getHeight();
            } else if (imageRatio < maxDimensionsRatio && image.getWidth() > maxWidth) {
                targetHeight = maxWidth * image.getHeight() / image.getWidth();
                targetWidth = maxWidth;
            }
            File tmp = File.createTempFile("RESIZED", null);
            image = ImageUtils.resizeImage(image, targetWidth, targetHeight);
            ImageIO.write((RenderedImage)image, extension, tmp);
            AvatarAttachment newAvatarAttachment = new AvatarAttachment(avatarId, avatarFileName, avatarMimeType, (InputStream)new FileInputStream(tmp), System.currentTimeMillis());
            tmp.delete();
            return newAvatarAttachment;
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to resize image to avatar attachment: " + String.valueOf(e)));
            return null;
        }
    }

    public static AvatarAttachment createDefaultAvatar(String identityId, String fullNameAbbreviation) {
        AvatarAttachment newAvatarAttachment = null;
        List<Color> colorList = List.of(new Color(239, 83, 80), new Color(25, 118, 210), new Color(171, 71, 188), new Color(0, 137, 123), new Color(158, 157, 36), new Color(251, 192, 45), new Color(0, 191, 165), new Color(117, 117, 117), new Color(244, 67, 54), new Color(33, 150, 243), new Color(124, 179, 66), new Color(48, 63, 159), new Color(69, 39, 160), new Color(141, 110, 99), new Color(255, 111, 0));
        BufferedImage image = new BufferedImage(350, 350, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(colorList.get(Integer.parseInt(identityId) % colorList.size()));
        graphics.fillRect(0, 0, 350, 350);
        graphics.setColor(Color.WHITE);
        graphics.setFont(new Font("Arial", 1, 150));
        FontMetrics fm = graphics.getFontMetrics();
        int x = (350 - fm.stringWidth(fullNameAbbreviation)) / 2;
        int y = fm.getAscent() + (350 - (fm.getAscent() + fm.getDescent())) / 2;
        graphics.drawString(fullNameAbbreviation, x, y);
        graphics.drawImage(image, 0, 0, 350, 350, null);
        graphics.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", outputStream);
            newAvatarAttachment = new AvatarAttachment(null, "DEFAULT_AVATAR", "image/png", (InputStream)new ByteArrayInputStream(outputStream.toByteArray()), System.currentTimeMillis());
            return newAvatarAttachment;
        }
        catch (IOException e) {
            LOG.warn("Fail to create default avatar for identity {}. Use default static avatar instead.", new Object[]{identityId, e});
            return null;
        }
    }

    private static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

