/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamConstants;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.controller.ManagedResponse;
import org.gatein.management.api.model.ModelList;
import org.gatein.management.api.model.ModelObject;
import org.gatein.management.api.model.ModelReference;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.rest.content.LinkBuilder;

@Provider
@Consumes(value={"application/xml", "application/json", "application/zip"})
@Produces(value={"application/xml", "application/json", "application/zip"})
public class ManagedResponseWriter
implements MessageBodyWriter<ManagedResponse>,
XMLStreamConstants {
    @Context
    private UriInfo uriInfo;

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return ManagedResponse.class.isAssignableFrom(aClass);
    }

    public long getSize(ManagedResponse managedResponse, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ManagedResponse managedResponse, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        String pretty = (String)this.uriInfo.getQueryParameters().getFirst((Object)"pretty");
        if (managedResponse.getResult() instanceof ModelValue) {
            ModelValue value = (ModelValue)managedResponse.getResult();
            ManagedResponseWriter.resolveLinks(value, this.uriInfo);
        }
        if ("false".equalsIgnoreCase(pretty)) {
            managedResponse.writeResult(outputStream, false);
        } else {
            managedResponse.writeResult(outputStream, true);
        }
    }

    private static void resolveLinks(ModelValue value, UriInfo uriInfo) {
        ModelValue.ModelValueType type = value.getValueType();
        switch (type) {
            case OBJECT: {
                ModelObject mo = (ModelObject)value.asValue(ModelObject.class);
                for (String name : mo.getNames()) {
                    ManagedResponseWriter.resolveLinks((ModelValue)mo.get(name), uriInfo);
                }
                break;
            }
            case REFERENCE: {
                ModelReference ref = (ModelReference)value.asValue(ModelReference.class);
                PathAddress address = ref.getValue();
                ref.remove("_ref");
                LinkBuilder linkBuilder = new LinkBuilder(uriInfo.getBaseUriBuilder());
                linkBuilder.path("/managed-components").path(address.toString());
                ref.get("url").set(linkBuilder.build().getHref());
                break;
            }
            case LIST: {
                for (ModelValue mv : (ModelList)value.asValue(ModelList.class)) {
                    ManagedResponseWriter.resolveLinks(mv, uriInfo);
                }
                break;
            }
        }
    }
}

