/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.listener;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.reward.listener.RewardReportUpdateListener$AjcClosure1;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.utils.RewardUtils;
import jakarta.annotation.PostConstruct;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class RewardReportUpdateListener
extends Listener<Object, Map<String, String>> {
    private static final List<String> EVENT_NAMES;
    @Autowired
    private RewardReportService rewardReportService;
    @Autowired
    private RewardSettingsService rewardSettingsService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private RealizationService realizationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(name -> this.listenerService.addListener(name, (ListenerBase)this));
    }

    @ContainerTransactional
    public void onEvent(Event<Object, Map<String, String>> event) {
        Event<Object, Map<String, String>> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        RewardReportUpdateListener$AjcClosure1 rewardReportUpdateListener$AjcClosure1 = new RewardReportUpdateListener$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(rewardReportUpdateListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private RealizationDTO getRealization(Object object) {
        if (object instanceof RealizationDTO) {
            RealizationDTO realization = (RealizationDTO)object;
            return realization;
        }
        if (object instanceof Announcement) {
            Announcement announcement = (Announcement)object;
            return this.realizationService.getRealizationById(announcement.getId());
        }
        return null;
    }

    static {
        RewardReportUpdateListener.ajc$preClinit();
        EVENT_NAMES = Arrays.asList("exo.wallet.addressAssociation.new", "exo.wallet.addressAssociation.modification", "reward.settings.updated", "announcement.created", "announcement.updated", "announcement.canceled", "realization.created", "realization.updated", "realization.canceled");
    }

    static final /* synthetic */ void onEvent_aroundBody0(RewardReportUpdateListener ajc$this, Event event, JoinPoint joinPoint) {
        String eventName = event.getEventName();
        Map<Long, Boolean> updatedSettings = ajc$this.rewardReportService.getRewardSettingChanged();
        if ("reward.settings.updated".equals(eventName)) {
            List rewardPeriods = ajc$this.rewardReportService.getRewardPeriodsNotSent();
            updatedSettings = rewardPeriods.stream().collect(Collectors.toMap(RewardPeriod::getId, rewardPeriod -> true));
        } else {
            RewardSettings rewardSettings = ajc$this.rewardSettingsService.getSettings();
            RealizationDTO realization = ajc$this.getRealization(event.getSource());
            RewardPeriod rewardPeriod2 = realization != null ? ajc$this.rewardReportService.getRewardPeriod(rewardSettings.getPeriodType(), Objects.requireNonNull(RewardUtils.parseRFC3339ToZonedDateTime((String)realization.getCreatedDate(), (ZoneId)rewardSettings.zoneId())).toLocalDate()) : ajc$this.rewardReportService.getRewardPeriod(rewardSettings.getPeriodType(), LocalDate.now());
            if (rewardPeriod2 == null) {
                return;
            }
            updatedSettings.put(rewardPeriod2.getId(), true);
        }
        ajc$this.rewardReportService.setRewardSettingChanged(updatedSettings);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RewardReportUpdateListener.java", RewardReportUpdateListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.wallet.reward.listener.RewardReportUpdateListener", "org.exoplatform.services.listener.Event", "event", "", "void"), 90);
    }
}

