/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;

@Entity(name="HibernateIdentityObjectRelationshipName")
@Table(name="jbid_io_rel_name")
@NamedQuery(name="HibernateIdentityObjectRelationshipName.findIdentityObjectRelationshipNameByName", query="select rn from HibernateIdentityObjectRelationshipName rn where rn.name like :name and rn.realm.name = :realmName")
public class HibernateIdentityObjectRelationshipName {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JBID_IO_REL_NAME_ID_SEQ")
    @SequenceGenerator(name="JBID_IO_REL_NAME_ID_SEQ", sequenceName="JBID_IO_REL_NAME_ID_SEQ", allocationSize=1)
    @Column(name="ID")
    private Long id;
    @Column(name="NAME", nullable=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REALM", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    private HibernateRealm realm;
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="PROP_NAME")
    @Column(name="PROP_VALUE")
    @CollectionTable(name="jbid_io_rel_name_props", joinColumns={@JoinColumn(name="PROP_ID", referencedColumnName="ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    private Map<String, String> properties = new HashMap<String, String>();

    public HibernateIdentityObjectRelationshipName() {
    }

    public HibernateIdentityObjectRelationshipName(String name, HibernateRealm realm) {
        this.name = name;
        this.realm = realm;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HibernateRealm getRealm() {
        return this.realm;
    }

    public void setRealm(HibernateRealm realm) {
        this.realm = realm;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

