/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;

public class StandardJdbcValuesMapping
implements JdbcValuesMapping {
    private final List<SqlSelection> sqlSelections;
    private final List<DomainResult<?>> domainResults;

    public StandardJdbcValuesMapping(List<SqlSelection> sqlSelections, List<DomainResult<?>> domainResults) {
        this.sqlSelections = sqlSelections;
        this.domainResults = domainResults;
    }

    @Override
    public List<SqlSelection> getSqlSelections() {
        return this.sqlSelections;
    }

    @Override
    public List<DomainResult<?>> getDomainResults() {
        return this.domainResults;
    }

    @Override
    public int getRowSize() {
        return this.sqlSelections.size();
    }

    @Override
    public List<DomainResultAssembler<?>> resolveAssemblers(AssemblerCreationState creationState) {
        ArrayList<DomainResultAssembler<?>> assemblers = CollectionHelper.arrayList(this.domainResults.size());
        for (int i = 0; i < this.domainResults.size(); ++i) {
            DomainResultAssembler<?> resultAssembler = this.domainResults.get(i).createResultAssembler(null, creationState);
            assemblers.add(resultAssembler);
        }
        return assemblers;
    }
}

