/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.parser.ElasticsearchQueryCreator;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.PartTree;

public class ElasticsearchPartQuery
extends AbstractElasticsearchRepositoryQuery {
    private final PartTree tree;
    private final MappingContext<?, ElasticsearchPersistentProperty> mappingContext;

    public ElasticsearchPartQuery(ElasticsearchQueryMethod method, ElasticsearchOperations elasticsearchOperations, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, elasticsearchOperations, evaluationContextProvider);
        this.tree = new PartTree(this.queryMethod.getName(), this.queryMethod.getResultProcessor().getReturnedType().getDomainType());
        this.mappingContext = this.elasticsearchConverter.getMappingContext();
    }

    @Override
    public boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected BaseQuery createQuery(ElasticsearchParametersParameterAccessor accessor) {
        BaseQuery query = (BaseQuery)new ElasticsearchQueryCreator(this.tree, accessor, this.mappingContext).createQuery();
        if (this.tree.getMaxResults() != null) {
            query.setMaxResults(this.tree.getMaxResults());
        }
        return query;
    }
}

