/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.component;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycleStack;

public class RequestLifeCycle {
    private static ThreadLocal<RequestLifeCycleStack> current = new ThreadLocal();
    private List<ComponentRequestLifecycle> components;
    private final ExoContainer container;

    public RequestLifeCycle(ExoContainer container, List<ComponentRequestLifecycle> components) {
        this.container = container;
        this.components = components;
    }

    void doBegin() {
        for (ComponentRequestLifecycle component : this.components) {
            component.startRequest(this.container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IdentityHashMap<Object, Throwable> doEnd() {
        IdentityHashMap<Object, Throwable> result = new IdentityHashMap<Object, Throwable>();
        for (ComponentRequestLifecycle componentRLF : this.components) {
            Throwable t = null;
            try {
                componentRLF.endRequest(this.container);
            }
            catch (Throwable throwable) {
                t = throwable;
            }
            finally {
                result.put(componentRLF, t);
            }
        }
        return result;
    }

    public static void begin(ExoContainer container, boolean local) {
        if (container == null) {
            throw new IllegalArgumentException("The container cannot be null");
        }
        RequestLifeCycleStack lf = current.get();
        if (lf == null) {
            lf = new RequestLifeCycleStack();
            current.set(lf);
        }
        lf.begin(container, local);
    }

    public static void begin(ComponentRequestLifecycle lifeCycle) {
        if (lifeCycle == null) {
            throw new IllegalArgumentException("The lifeCycle cannot be null");
        }
        RequestLifeCycleStack lf = current.get();
        if (lf == null) {
            lf = new RequestLifeCycleStack();
            current.set(lf);
        }
        lf.begin(lifeCycle);
    }

    public static void begin(ExoContainer container) {
        RequestLifeCycle.begin(container, false);
    }

    public static Map<Object, Throwable> end() throws IllegalStateException {
        RequestLifeCycleStack lf = current.get();
        if (lf == null) {
            throw new IllegalStateException();
        }
        Map<Object, Throwable> result = lf.end();
        if (lf.isEmpty()) {
            current.set(null);
        }
        return result;
    }

    protected void restartTransaction() {
        this.restartTransaction(ExoContainerContext.getCurrentContainer());
    }

    protected void restartTransaction(ExoContainer container) {
        int i = 0;
        boolean success = true;
        do {
            try {
                RequestLifeCycle.end();
                ++i;
            }
            catch (IllegalStateException e) {
                success = false;
            }
        } while (success);
        for (int j = 0; j < i; ++j) {
            RequestLifeCycle.begin(container);
        }
    }

    public static boolean isStarted(ComponentRequestLifecycle lifeCycle) {
        if (lifeCycle == null) {
            throw new IllegalArgumentException("The lifeCycle cannot be null");
        }
        RequestLifeCycleStack lf = current.get();
        return lf == null ? false : lf.isStarted(lifeCycle);
    }

    public static boolean isStarted(ExoContainer container, boolean local) {
        if (container == null) {
            throw new IllegalArgumentException("The container cannot be null");
        }
        RequestLifeCycleStack lf = current.get();
        return lf == null ? false : lf.isStarted(container, local);
    }
}

