/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.query.GroupQuery;
import org.picketlink.idm.api.query.GroupQueryBuilder;
import org.picketlink.idm.api.query.UnsupportedQueryCriterium;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.api.query.AbstractQueryBuilder;
import org.picketlink.idm.impl.api.query.GroupQueryImpl;

public class GroupQueryBuilderImpl
extends AbstractQueryBuilder
implements GroupQueryBuilder {
    private GroupKey groupKey;
    private String groupName;
    private String groupType;
    private Set<Group> associatedParentGroups = new HashSet<Group>();
    private Set<Group> associatedChildGroups = new HashSet<Group>();
    private Set<User> usersAssociated = new HashSet<User>();
    private Set<User> usersRelated = new HashSet<User>();
    private Set<User> usersConnectedByRole = new HashSet<User>();

    private void prepare() {
        if (this.groupKey == null && this.groupName != null && this.groupType != null) {
            this.groupKey = new GroupKey(this.groupName, this.groupType);
        }
    }

    public GroupQuery createQuery() {
        this.prepare();
        return new GroupQueryImpl(this.searchCriteria, this.groupKey, this.groupName, this.groupType, this.associatedParentGroups, this.associatedChildGroups, this.usersAssociated, this.usersRelated, this.usersConnectedByRole);
    }

    public GroupQueryBuilder reset() {
        this.searchCriteria = new IdentitySearchCriteriaImpl();
        this.groupKey = null;
        this.groupName = null;
        this.groupType = null;
        this.associatedParentGroups = new HashSet<Group>();
        this.associatedChildGroups = new HashSet<Group>();
        this.usersAssociated = new HashSet<User>();
        this.usersRelated = new HashSet<User>();
        this.usersConnectedByRole = new HashSet<User>();
        return this;
    }

    public GroupQueryBuilder setKey(String id) {
        this.groupKey = new GroupKey(id);
        return this;
    }

    public GroupQueryBuilder setNameAndType(String name, String type) {
        this.groupKey = new GroupKey(name, type);
        this.groupName = name;
        this.groupType = type;
        return this;
    }

    public GroupQueryBuilder setName(String name) {
        this.checkNotNullArgument(name, "Group name");
        this.groupName = name;
        return this;
    }

    public GroupQueryBuilder setType(String type) {
        this.checkNotNullArgument(type, "Group type");
        this.groupType = type;
        return this;
    }

    public GroupQueryBuilder addAssociatedGroup(Group group, boolean parent) {
        this.checkNotNullArgument(group, "Group");
        if (parent) {
            this.associatedParentGroups.add(group);
        } else {
            this.associatedChildGroups.add(group);
        }
        return this;
    }

    public GroupQueryBuilder addAssociatedGroup(String id, boolean parent) {
        this.checkNotNullArgument(id, "Group id");
        SimpleGroup group = new SimpleGroup(new GroupKey(id));
        if (parent) {
            this.associatedParentGroups.add(group);
        } else {
            this.associatedChildGroups.add(group);
        }
        return this;
    }

    public GroupQueryBuilder addAssociatedGroups(Collection<Group> groups, boolean parent) {
        this.checkNotNullArgument(groups, "Groups");
        if (parent) {
            this.associatedParentGroups.addAll(groups);
        } else {
            this.associatedChildGroups.addAll(groups);
        }
        return this;
    }

    public GroupQueryBuilder addAssociatedGroupsKeys(Collection<String> ids, boolean parent) {
        this.checkNotNullArgument(ids, "Groups ids");
        for (String groupId : ids) {
            SimpleGroup group = new SimpleGroup(new GroupKey(groupId));
            if (parent) {
                this.associatedParentGroups.add(group);
                continue;
            }
            this.associatedChildGroups.add(group);
        }
        return this;
    }

    public GroupQueryBuilder addAssociatedUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.usersAssociated.add(user);
        return this;
    }

    public GroupQueryBuilder addAssociatedUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.usersAssociated.add(new SimpleUser(id));
        return this;
    }

    public GroupQueryBuilder addAssociatedUsers(Collection<User> users) {
        this.checkNotNullArgument(users, "Users");
        this.usersAssociated.addAll(users);
        return this;
    }

    public GroupQueryBuilder addAssociatedUsersKeys(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Users ids");
        for (String id : ids) {
            this.usersAssociated.add(new SimpleUser(id));
        }
        return this;
    }

    public GroupQueryBuilder addUserConnectedByRole(User user) {
        this.checkNotNullArgument(user, "User");
        this.usersConnectedByRole.add(user);
        return this;
    }

    public GroupQueryBuilder addUserConnectedByRole(String id) {
        this.checkNotNullArgument(id, "User id");
        this.usersConnectedByRole.add(new SimpleUser(id));
        return this;
    }

    public GroupQueryBuilder addUsersConnectedByRole(Collection<User> users) {
        this.checkNotNullArgument(users, "Users");
        this.usersConnectedByRole.addAll(users);
        return this;
    }

    public GroupQueryBuilder addUsersIdsConnectedByRole(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Users ids");
        for (String id : ids) {
            this.usersConnectedByRole.add(new SimpleUser(id));
        }
        return this;
    }

    public GroupQueryBuilder addRelatedUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.usersRelated.add(user);
        return this;
    }

    public GroupQueryBuilder addRelatedUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.usersRelated.add(new SimpleUser(id));
        return this;
    }

    public GroupQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (GroupQueryBuilder)super.sort(order);
    }

    public GroupQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (GroupQueryBuilder)super.sortAttributeName(name);
    }

    public GroupQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (GroupQueryBuilder)super.page(firstResult, maxResults);
    }

    public GroupQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (GroupQueryBuilder)super.attributeValuesFilter(attributeName, attributeValue);
    }
}

