/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth2.clientauthentication;

import com.github.scribejava.core.java8.Base64;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth2.clientauthentication.ClientAuthentication;
import java.nio.charset.Charset;

public class HttpBasicAuthenticationScheme
implements ClientAuthentication {
    private final Base64.Encoder base64Encoder = Base64.getEncoder();

    protected HttpBasicAuthenticationScheme() {
    }

    public static HttpBasicAuthenticationScheme instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public void addClientAuthentication(OAuthRequest request, String apiKey, String apiSecret) {
        if (apiKey != null && apiSecret != null) {
            request.addHeader("Authorization", "Basic " + this.base64Encoder.encodeToString(String.format("%s:%s", apiKey, apiSecret).getBytes(Charset.forName("UTF-8"))));
        }
    }

    private static class InstanceHolder {
        private static final HttpBasicAuthenticationScheme INSTANCE = new HttpBasicAuthenticationScheme();

        private InstanceHolder() {
        }
    }
}

