/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.elasticsearch.storage;

import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchConfiguration {
    private static final Log LOG = ExoLogger.getLogger(ElasticsearchConfiguration.class);
    private static final String DEFAULT_ES_CLIENT_SERVER_URL = "http://127.0.0.1:9200";
    private static final String ES_CLIENT_SERVER_URL = "exo.es.index.server.url";
    private static final String ES_CLIENT_USERNAME = "exo.es.index.server.username";
    private static final String ES_CLIENT_PWD = "exo.es.index.server.password";
    public static final String ES_ANALYTICS_INDEX_TEMPLATE = "exo.es.analytics.index.template";
    public static final String DEFAULT_ES_INDEX_TEMPLATE = "analytics_template";
    public static final Context ES_ANALYTICS_CONTEXT = Context.GLOBAL.id("analytics");
    public static final Scope ES_ANALYTICS_SCOPE = Scope.APPLICATION.id("analytics");
    @Autowired
    private SettingService settingService;
    @Value(value="${analytics.es.index.prefix:analytics}")
    private String indexPrefix;
    @Value(value="${analytics.es.index.template:analytics_template}")
    private String indexTemplateName;
    @Value(value="${analytics.es.index.alias:analytics_alias}")
    private String indexAlias;
    @Value(value="${analytics.es.index.writePeriod:7}")
    private long indexPerDays;
    @Value(value="${analytics.es.index.maxCount:500}")
    private long maxIndexCount;
    @Value(value="${analytics.es.replicas:0}")
    private int replicas;
    @Value(value="${analytics.es.shards:1}")
    private int shards;
    @Value(value="${analytics.es.index.template.path:analytics-es-template.json}")
    private String indexTemplateMappingFilePath;
    private String indexTemplateMapping;
    @Value(value="${analytics.es.index.server.username:}")
    private String username;
    @Value(value="${analytics.es.index.server.password:}")
    private String password;
    @Value(value="${analytics.es.index.server.url:}")
    private String urlClient;

    @PostConstruct
    public void init() {
        this.computeConnectionProperties();
        this.computeIndexTemplateName();
        this.computeIndexTemplateMapping();
    }

    @Bean(value={"elasticsearchHttpClient"})
    private HttpClient elasticsearchHttpClient() {
        PoolingHttpClientConnectionManager clientConnectionManager = new PoolingHttpClientConnectionManager();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().disableAutomaticRetries().setConnectionManager((HttpClientConnectionManager)clientConnectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(this.username, this.password.toCharArray()));
            return httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        }
        return httpClientBuilder.build();
    }

    private void computeIndexTemplateMapping() {
        InputStream mappingFileIS = this.getClass().getClassLoader().getResourceAsStream("analytics-es-template.json");
        this.indexTemplateMapping = IOUtil.getStreamContentAsString((InputStream)mappingFileIS);
        this.indexTemplateMapping = this.indexTemplateMapping.replace(DEFAULT_ES_INDEX_TEMPLATE, this.getIndexAlias()).replace("replica.number", String.valueOf(this.replicas)).replace("shard.number", String.valueOf(this.shards));
    }

    private void computeConnectionProperties() {
        if (StringUtils.isBlank((CharSequence)this.urlClient)) {
            this.urlClient = System.getProperty(ES_CLIENT_SERVER_URL);
            this.username = System.getProperty(ES_CLIENT_USERNAME);
            this.password = System.getProperty(ES_CLIENT_PWD);
        }
        if (StringUtils.isBlank((CharSequence)this.urlClient)) {
            this.urlClient = DEFAULT_ES_CLIENT_SERVER_URL;
        }
    }

    private void computeIndexTemplateName() {
        SettingValue indexTemplateValue = this.settingService.get(ES_ANALYTICS_CONTEXT, ES_ANALYTICS_SCOPE, ES_ANALYTICS_INDEX_TEMPLATE);
        if (indexTemplateValue == null || indexTemplateValue.getValue() == null) {
            this.settingService.set(ES_ANALYTICS_CONTEXT, ES_ANALYTICS_SCOPE, ES_ANALYTICS_INDEX_TEMPLATE, SettingValue.create((String)this.indexTemplateName));
        } else {
            String storedIndexTemplate = indexTemplateValue.getValue().toString();
            if (!StringUtils.equals((CharSequence)storedIndexTemplate, (CharSequence)this.indexTemplateName)) {
                LOG.warn("Can't change index template from {} to {}. New index will be ignored.", new Object[]{storedIndexTemplate, this.indexTemplateName});
                this.indexTemplateName = storedIndexTemplate;
            }
        }
    }

    @Generated
    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    @Generated
    public String getIndexTemplateName() {
        return this.indexTemplateName;
    }

    @Generated
    public String getIndexAlias() {
        return this.indexAlias;
    }

    @Generated
    public long getIndexPerDays() {
        return this.indexPerDays;
    }

    @Generated
    public long getMaxIndexCount() {
        return this.maxIndexCount;
    }

    @Generated
    public String getIndexTemplateMapping() {
        return this.indexTemplateMapping;
    }

    @Generated
    public String getUrlClient() {
        return this.urlClient;
    }
}

