/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Map;
import java.util.Set;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.DeleteIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveIndexOperations {
    public Mono<Boolean> create();

    public Mono<Boolean> create(Map<String, Object> var1);

    public Mono<Boolean> create(Map<String, Object> var1, Document var2);

    public Mono<Boolean> createWithMapping();

    public Mono<Boolean> delete();

    public Mono<Boolean> exists();

    public Mono<Void> refresh();

    public Mono<Document> createMapping();

    public Mono<Document> createMapping(Class<?> var1);

    default public Mono<Boolean> putMapping() {
        return this.putMapping(this.createMapping());
    }

    public Mono<Boolean> putMapping(Mono<Document> var1);

    default public Mono<Boolean> putMapping(Class<?> clazz) {
        return this.putMapping(this.createMapping(clazz));
    }

    public Mono<Document> getMapping();

    public Mono<Settings> createSettings();

    public Mono<Settings> createSettings(Class<?> var1);

    default public Mono<Settings> getSettings() {
        return this.getSettings(false);
    }

    public Mono<Settings> getSettings(boolean var1);

    public Mono<Boolean> alias(AliasActions var1);

    public Mono<Map<String, Set<AliasData>>> getAliases(String ... var1);

    public Mono<Map<String, Set<AliasData>>> getAliasesForIndex(String ... var1);

    @Deprecated
    public Mono<Boolean> putTemplate(PutTemplateRequest var1);

    public Mono<Boolean> putComponentTemplate(PutComponentTemplateRequest var1);

    public Flux<TemplateResponse> getComponentTemplate(GetComponentTemplateRequest var1);

    public Mono<Boolean> existsComponentTemplate(ExistsComponentTemplateRequest var1);

    public Mono<Boolean> deleteComponentTemplate(DeleteComponentTemplateRequest var1);

    public Mono<Boolean> putIndexTemplate(PutIndexTemplateRequest var1);

    default public Mono<Boolean> existsIndexTemplate(String indexTemplateName) {
        return this.existsIndexTemplate(new ExistsIndexTemplateRequest(indexTemplateName));
    }

    public Mono<Boolean> existsIndexTemplate(ExistsIndexTemplateRequest var1);

    default public Flux<TemplateResponse> getIndexTemplate(String indexTemplateName) {
        return this.getIndexTemplate(new GetIndexTemplateRequest(indexTemplateName));
    }

    public Flux<TemplateResponse> getIndexTemplate(GetIndexTemplateRequest var1);

    default public Mono<Boolean> deleteIndexTemplate(String indexTemplateName) {
        return this.deleteIndexTemplate(new DeleteIndexTemplateRequest(indexTemplateName));
    }

    public Mono<Boolean> deleteIndexTemplate(DeleteIndexTemplateRequest var1);

    @Deprecated
    default public Mono<TemplateData> getTemplate(String templateName) {
        return this.getTemplate(new GetTemplateRequest(templateName));
    }

    @Deprecated
    public Mono<TemplateData> getTemplate(GetTemplateRequest var1);

    @Deprecated
    default public Mono<Boolean> existsTemplate(String templateName) {
        return this.existsTemplate(new ExistsTemplateRequest(templateName));
    }

    @Deprecated
    public Mono<Boolean> existsTemplate(ExistsTemplateRequest var1);

    @Deprecated
    default public Mono<Boolean> deleteTemplate(String templateName) {
        return this.deleteTemplate(new DeleteTemplateRequest(templateName));
    }

    @Deprecated
    public Mono<Boolean> deleteTemplate(DeleteTemplateRequest var1);

    default public Flux<IndexInformation> getInformation() {
        return this.getInformation(this.getIndexCoordinates());
    }

    public Flux<IndexInformation> getInformation(IndexCoordinates var1);

    public IndexCoordinates getIndexCoordinates();
}

