/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.metadata.model.MetadataItem;

public abstract class MetadataListenerBase
extends Listener<Long, MetadataItem> {
    private static final String RULE_METADATA_TYPE = "rule";
    private RuleService ruleService;
    private IndexingService indexingService;

    MetadataListenerBase(RuleService ruleService, IndexingService indexingService) {
        this.ruleService = ruleService;
        this.indexingService = indexingService;
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = metadataItem.getObjectType();
        if (!StringUtils.equals((CharSequence)objectType, (CharSequence)RULE_METADATA_TYPE)) {
            return;
        }
        String ruleId = metadataItem.getObjectId();
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(ruleId));
        if (rule == null) {
            this.indexingService.unindex("rules", ruleId);
        } else {
            this.indexingService.reindex("rules", ruleId);
        }
    }
}

