/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.rest;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.model.StatisticData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"samples"})
@Tag(name="samples", description="Retrieve Analytics Samples")
public class AnalyticsSampleRest {
    @Autowired
    private AnalyticsService analyticsService;

    @GetMapping
    @Secured(value={"analytics"})
    @Operation(summary="Retrieve Analytics Samples", method="GET", description="This will allow for an administrator to retrieve collected statistics without user ACL retrictions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<StatisticData> getSamples(@Parameter(description="Collected Statistic Operations to consider in query", required=false) @RequestParam(name="operation", required=false) List<String> operations, @Parameter(description="Filtered field name", required=false) @RequestParam(name="fieldName", required=false) String fieldName, @Parameter(description="Filtered field values", required=false) @RequestParam(name="fieldValue", required=false) List<String> fieldValues, @Parameter(description="Sort field name", required=true) @RequestParam(value="sortBy") String sortBy, @Parameter(description="Sort direction: asc or desc", required=true) @RequestParam(value="sortDirection") String sortDirection, @Parameter(description="Limit of samples to retrieve", required=true) @RequestParam(value="limit") int limit) {
        return this.analyticsService.getSamples(operations, fieldName, fieldValues, sortBy, sortDirection, limit);
    }
}

