/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.values.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.JdbcValuesMappingImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class GeneratedValuesMappingProducer
implements JdbcValuesMappingProducer {
    private final List<GeneratedValueBasicResultBuilder> resultBuilders = new ArrayList<GeneratedValueBasicResultBuilder>();

    @Override
    public JdbcValuesMapping resolve(JdbcValuesMetadata jdbcResultsMetadata, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        int numberOfResults = this.resultBuilders.size();
        int rowSize = jdbcResultsMetadata.getColumnCount();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(rowSize);
        ArrayList domainResults = new ArrayList(numberOfResults);
        DomainResultCreationStateImpl creationState = new DomainResultCreationStateImpl(null, jdbcResultsMetadata, null, sqlSelections::add, loadQueryInfluencers, sessionFactory);
        for (int i = 0; i < numberOfResults; ++i) {
            ResultBuilder resultBuilder = this.resultBuilders.get(i);
            DomainResult<?> domainResult = resultBuilder.buildResult(jdbcResultsMetadata, domainResults.size(), creationState.getLegacyFetchResolver()::resolve, creationState);
            if (domainResult.containsAnyNonScalarResults()) {
                creationState.disallowPositionalSelections();
            }
            domainResults.add(domainResult);
        }
        return new JdbcValuesMappingImpl(sqlSelections, domainResults, rowSize, creationState.getRegisteredLockModes());
    }

    public void addResultBuilder(GeneratedValueBasicResultBuilder resultBuilder) {
        this.resultBuilders.add(resultBuilder);
    }

    public List<GeneratedValueBasicResultBuilder> getResultBuilders() {
        return this.resultBuilders;
    }

    @Override
    public void addAffectedTableNames(Set<String> affectedTableNames, SessionFactoryImplementor sessionFactory) {
    }
}

