/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.ElserServiceSettings;
import co.elastic.clients.elasticsearch.inference.ElserServiceType;
import co.elastic.clients.elasticsearch.inference.ElserTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutElserResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@Deprecated
@JsonpDeserializable
public class PutElserRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String elserInferenceId;
    private final ElserServiceType service;
    private final ElserServiceSettings serviceSettings;
    private final ElserTaskType taskType;
    public static final JsonpDeserializer<PutElserRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutElserRequest::setupPutElserRequestDeserializer);
    public static final Endpoint<PutElserRequest, PutElserResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutElserRequest, PutElserResponse>("es/inference.put_elser", request -> "PUT", request -> {
        boolean _taskType = true;
        int _elserInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.elserInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _elserInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("elserInferenceId", request.elserInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutElserResponse._DESERIALIZER);

    private PutElserRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.elserInferenceId = ApiTypeHelper.requireNonNull(builder.elserInferenceId, this, "elserInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutElserRequest of(Function<Builder, ObjectBuilder<PutElserRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String elserInferenceId() {
        return this.elserInferenceId;
    }

    public final ElserServiceType service() {
        return this.service;
    }

    public final ElserServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final ElserTaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutElserRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, ElserServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, ElserServiceSettings._DESERIALIZER, "service_settings");
    }

    @Deprecated
    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutElserRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String elserInferenceId;
        private ElserServiceType service;
        private ElserServiceSettings serviceSettings;
        private ElserTaskType taskType;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder elserInferenceId(String value) {
            this.elserInferenceId = value;
            return this;
        }

        public final Builder service(ElserServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(ElserServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<ElserServiceSettings.Builder, ObjectBuilder<ElserServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new ElserServiceSettings.Builder()).build());
        }

        public final Builder taskType(ElserTaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutElserRequest build() {
            this._checkSingleUse();
            return new PutElserRequest(this);
        }
    }
}

