/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

public class SocialMembershipListenerImpl
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger(SocialMembershipListenerImpl.class);

    public void preDelete(Membership m) throws Exception {
        if (m.getGroupId().startsWith("/spaces") && ("member".equals(m.getMembershipType()) || "*".equals(m.getMembershipType()))) {
            Space space = ((SpaceService)ExoContainerContext.getService(SpaceService.class)).getSpaceByGroupId(m.getGroupId());
            GroupSpaceBindingService groupBindingService = (GroupSpaceBindingService)ExoContainerContext.getService(GroupSpaceBindingService.class);
            if (space != null && groupBindingService.countUserBindings(space.getId(), m.getUserName()) > 0L) {
                throw new IllegalStateException("space.cantLeaveBoundSpace");
            }
        }
    }

    public void postDelete(Membership m) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            UserACL acl = (UserACL)CommonsUtils.getService(UserACL.class);
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                boolean hasPublisherMembership;
                boolean hasMemberMembership;
                boolean hasManagerMembership;
                ConversationState state = ConversationState.getCurrent();
                if (state != null && state.getIdentity() != null && space.getEditor() == null) {
                    space.setEditor(state.getIdentity().getUserId());
                }
                IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
                Identity deletedMembershipIdentity = identityRegistry.getIdentity(m.getUserName());
                OrganizationService orgService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
                boolean bl = deletedMembershipIdentity != null ? deletedMembershipIdentity.isMemberOf(m.getGroupId(), acl.getAdminMSType()) : (hasManagerMembership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), acl.getAdminMSType()) != null);
                boolean bl2 = deletedMembershipIdentity != null ? deletedMembershipIdentity.isMemberOf(m.getGroupId(), "member") : (hasMemberMembership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), "member") != null);
                boolean bl3 = deletedMembershipIdentity != null ? deletedMembershipIdentity.isMemberOf(m.getGroupId(), "publisher") : (hasPublisherMembership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), "publisher") != null);
                if (!hasManagerMembership) {
                    spaceService.setManager(space, m.getUserName(), false);
                }
                if (!hasMemberMembership) {
                    spaceService.removeMember(space, m.getUserName());
                }
                if (!hasPublisherMembership) {
                    spaceService.removePublisher(space, m.getUserName());
                }
                this.refreshNavigation();
                this.clearOwnerGlobalStreamCache(m.getUserName());
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            UserACL acl = (UserACL)ExoContainerContext.getService(UserACL.class);
            SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                ConversationState state = ConversationState.getCurrent();
                if (state != null && state.getIdentity() != null && space.getEditor() == null) {
                    space.setEditor(state.getIdentity().getUserId());
                }
                String userName = m.getUserName();
                this.clearOwnerGlobalStreamCache(userName);
                if (acl.getAdminMSType().equalsIgnoreCase(m.getMembershipType()) || "*".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isManager(space, userName)) {
                        return;
                    }
                    if (spaceService.isMember(space, userName)) {
                        spaceService.setManager(space, userName, true);
                    } else {
                        spaceService.addMember(space, userName);
                        spaceService.setManager(space, userName, true);
                    }
                } else if ("member".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isMember(space, userName)) {
                        return;
                    }
                    spaceService.addMember(space, userName);
                } else if ("redactor".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isRedactor(space, userName)) {
                        return;
                    }
                    spaceService.addRedactor(space, userName);
                } else if ("publisher".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isPublisher(space, userName)) {
                        return;
                    }
                    spaceService.addPublisher(space, userName);
                }
                this.refreshNavigation();
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    private void refreshNavigation() {
        try {
            UserPortal userPortal = this.getUserPortal();
            if (userPortal != null) {
                userPortal.refresh();
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"It seem that we don't have a WebUI context, ignoring.", (Throwable)e);
            }
            LOG.warn("It seem that we don't have a WebUI context, error message: {}. Ignoring.", new Object[]{e.getMessage()});
        }
    }

    private UserPortal getUserPortal() {
        try {
            PortalRequestContext prc = Util.getPortalRequestContext();
            return prc.getUserPortalConfig().getUserPortal();
        }
        catch (Exception e) {
            try {
                return this.getUserPortalForRest();
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    private UserPortal getUserPortalForRest() {
        return this.getUserPortalConfig().getUserPortal();
    }

    private UserPortalConfig getUserPortalConfig() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        ConversationState conversationState = ConversationState.getCurrent();
        String remoteId = conversationState == null ? null : conversationState.getIdentity().getUserId();
        return userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getMetaPortal(), remoteId);
    }

    private void clearIdentityCaching() {
        IdentityStorage storage = (IdentityStorage)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityStorage.class);
        storage.updateIdentityMembership(null);
    }

    protected void clearOwnerGlobalStreamCache(String owner) {
        CachedActivityStorage cachedActivityStorage = (CachedActivityStorage)CommonsUtils.getService(CachedActivityStorage.class);
        cachedActivityStorage.clearOwnerStreamCache(owner);
    }
}

