/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.url.simple;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.simple.SimpleURL;
import org.gatein.common.io.UndeclaredIOException;

public class SimpleURLContext
implements URLContext {
    private static final String HTTP_SCHEME = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_REQUEST_HANDLER = "portal";
    private URIWriter writer;
    private StringBuilder buffer;
    private Router router;
    protected String scheme;
    protected String host;
    protected int port;
    protected String servletContext;
    protected String requestHandler;

    public SimpleURLContext(String scheme, String host, int port, String servletContext, String requestHandler, Router router) {
        if (router == null) {
            throw new IllegalArgumentException("Router cannot be null");
        }
        this.router = router;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.servletContext = servletContext;
        this.requestHandler = requestHandler;
        this.buffer = new StringBuilder();
        this.writer = new URIWriter(this.buffer);
    }

    public SimpleURLContext(String servletContext, Router router) {
        this(HTTP_SCHEME, DEFAULT_HOST, 8080, servletContext, DEFAULT_REQUEST_HANDLER, router);
    }

    public SimpleURLContext(HttpServletRequest httpRequest, PortalContainer container, WebAppController controller) {
        this(httpRequest.getScheme(), httpRequest.getRemoteHost(), httpRequest.getServerPort(), container.getName(), DEFAULT_REQUEST_HANDLER, controller.getRouter());
    }

    public SimpleURLContext(PortalContainer container, WebAppController controller) {
        this(container.getName(), controller.getRouter());
    }

    @Override
    public <R, U extends PortalURL<R, U>> String render(U url) {
        try {
            return this._render(url);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    private <R, U extends PortalURL<R, U>> String _render(U url) throws IOException {
        boolean ajax;
        if (url.getResource() == null) {
            throw new IllegalStateException("No resource set on portal URL");
        }
        if (this.writer == null) {
            this.buffer = new StringBuilder();
            this.writer = new URIWriter(this.buffer);
        } else {
            this.buffer.setLength(0);
            this.writer.reset(this.buffer);
        }
        if (url.getSchemeUse()) {
            this.buffer.append(this.scheme).append("://");
        }
        if (url.getAuthorityUse()) {
            this.buffer.append(this.host);
            if (this.port != 80) {
                this.buffer.append(':').append(this.port);
            }
        }
        this.writer.setMimeType(url.getMimeType());
        String confirm = url.getConfirm();
        boolean hasConfirm = confirm != null && confirm.length() > 0;
        boolean bl = ajax = url.getAjax() != null && url.getAjax() != false;
        if (ajax) {
            this.writer.append("javascript:");
            if (hasConfirm) {
                this.writer.append("if(confirm('");
                this.writer.append(confirm.replaceAll("'", "\\\\'"));
                this.writer.append("'))");
            }
            this.writer.append("ajaxGet('");
        } else if (hasConfirm) {
            this.writer.append("javascript:");
            this.writer.append("if(confirm('");
            this.writer.append(confirm.replaceAll("'", "\\\\'"));
            this.writer.append("'))");
            this.writer.append("window.location='");
        }
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(WebAppController.HANDLER_PARAM, this.requestHandler);
        String lang = "";
        Locale locale = url.getLocale();
        if (locale != null && locale.getLanguage().length() > 0) {
            lang = I18N.toTagIdentifier((Locale)locale);
        }
        parameters.put(SimpleURL.LANG, lang);
        for (QualifiedName parameterName : url.getParameterNames()) {
            String parameterValue = url.getParameterValue(parameterName);
            if (parameterValue == null) continue;
            parameters.put(parameterName, parameterValue);
        }
        this.writer.append("/");
        this.writer.appendSegment(this.servletContext);
        this.router.render(parameters, this.writer);
        Map<String, String[]> queryParameters = url.getQueryParameters();
        if (queryParameters != null) {
            for (Map.Entry<String, String[]> entry : queryParameters.entrySet()) {
                for (String value : entry.getValue()) {
                    this.writer.appendQueryParameter(entry.getKey(), value);
                }
            }
        }
        if (ajax) {
            this.writer.appendQueryParameter("ajaxRequest", "true");
            this.writer.append("')");
        } else if (hasConfirm) {
            this.writer.append("'");
        }
        return this.buffer.toString();
    }
}

