/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.storage;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.reward.service.RewardReportService;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HubReportStorage {
    public static final Context UEM_CONTEXT = Context.GLOBAL.id("HubUEM");
    public static final String REWARD_REPORT_ID = "HubReportId";
    public static final String REWARD_PERIOD_ID = "HubPeriodId";
    public static final String REWARD_REPORT_STATUS = "HubReportStatus";
    public static final String REWARD_REPORT_SENT_DATE = "HubReportSentDate";
    public static final Scope REWARD_REPORT_STATUS_APPLICATION = Scope.APPLICATION.id("HubReportStatus");
    public static final Scope REWARD_REPORT_SENT_DATE_APPLICATION = Scope.APPLICATION.id("HubReportSentDate");
    public static final Scope REWARD_REPORT_ID_APPLICATION = Scope.APPLICATION.id("HubReportId");
    public static final Scope REWARD_PERIOD_ID_APPLICATION = Scope.APPLICATION.id("HubPeriodId");
    @Autowired
    private SettingService settingService;
    @Autowired
    private RewardReportService rewardReportService;

    public void saveStatus(RewardPeriod rewardPeriod, String status) {
        long periodId = this.getPeriodKey(rewardPeriod);
        this.saveStatus(periodId, status);
    }

    public void saveStatus(long periodId, String status) {
        this.settingService.set(UEM_CONTEXT, REWARD_REPORT_STATUS_APPLICATION, String.valueOf(periodId), SettingValue.create((String)status));
    }

    public void saveReportPeriodId(RewardPeriod rewardPeriod, long reportId) {
        long periodId = this.getPeriodKey(rewardPeriod);
        this.saveReportPeriodId(periodId, reportId);
    }

    public void saveReportPeriodId(long periodId, long reportId) {
        this.settingService.set(UEM_CONTEXT, REWARD_REPORT_ID_APPLICATION, String.valueOf(periodId), SettingValue.create((String)String.valueOf(reportId)));
        this.settingService.set(UEM_CONTEXT, REWARD_PERIOD_ID_APPLICATION, String.valueOf(reportId), SettingValue.create((String)String.valueOf(periodId)));
    }

    public void saveSentDate(RewardPeriod rewardPeriod, Instant sentDate) {
        long periodId = this.getPeriodKey(rewardPeriod);
        this.settingService.set(UEM_CONTEXT, REWARD_REPORT_SENT_DATE_APPLICATION, String.valueOf(periodId), SettingValue.create((String)String.valueOf(sentDate.toEpochMilli())));
    }

    public String getStatus(RewardPeriod rewardPeriod) {
        long periodId = this.getPeriodKey(rewardPeriod);
        SettingValue statusValue = this.settingService.get(UEM_CONTEXT, REWARD_REPORT_STATUS_APPLICATION, String.valueOf(periodId));
        return statusValue == null || statusValue.getValue() == null ? null : statusValue.getValue().toString();
    }

    public long getReportId(RewardPeriod rewardPeriod) {
        long periodId = this.getPeriodKey(rewardPeriod);
        return this.getReportId(periodId);
    }

    public long getReportId(long periodId) {
        SettingValue settingValue = this.settingService.get(UEM_CONTEXT, REWARD_REPORT_ID_APPLICATION, String.valueOf(periodId));
        return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
    }

    public long getPeriodId(long reportId) {
        SettingValue settingValue = this.settingService.get(UEM_CONTEXT, REWARD_PERIOD_ID_APPLICATION, String.valueOf(reportId));
        return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
    }

    public Instant getSentDate(RewardPeriod rewardPeriod) {
        long periodId = this.getPeriodKey(rewardPeriod);
        return this.getSentDate(periodId);
    }

    public Instant getSentDate(long periodId) {
        String sentDateString;
        SettingValue settingValue = this.settingService.get(UEM_CONTEXT, REWARD_REPORT_SENT_DATE_APPLICATION, String.valueOf(periodId));
        String string = sentDateString = settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
        if (StringUtils.isBlank(sentDateString)) {
            return Instant.now();
        }
        return Instant.ofEpochMilli(Long.parseLong(sentDateString));
    }

    public long getPeriodKey(RewardPeriod rewardPeriod) {
        if (rewardPeriod.getId() > 0L) {
            return rewardPeriod.getId();
        }
        if ((rewardPeriod = this.rewardReportService.getRewardPeriod(rewardPeriod.getRewardPeriodType(), rewardPeriod.getPeriodMedianDate())) == null || rewardPeriod.getId() == 0L) {
            throw new IllegalStateException("Selected Reward period, doesn't have a matching id: " + String.valueOf(rewardPeriod));
        }
        return rewardPeriod.getId();
    }
}

