/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.analytics.AnalyticsBatch;
import liquibase.analytics.AnalyticsListener;
import liquibase.analytics.Event;
import liquibase.analytics.configuration.AnalyticsArgs;
import liquibase.analytics.configuration.AnalyticsConfigurationFactory;
import liquibase.analytics.configuration.LiquibaseRemoteAnalyticsConfiguration;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.logging.Logger;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.util.ExceptionUtil;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.nodes.Tag;

public class LiquibaseAnalyticsListener
implements AnalyticsListener {
    @Override
    public int getPriority() {
        boolean analyticsEnabled = false;
        try {
            analyticsEnabled = AnalyticsArgs.isAnalyticsEnabled();
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(AnalyticsListener.class).log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "Failed to determine if analytics is enabled", e);
        }
        if (analyticsEnabled) {
            return 10;
        }
        return -1;
    }

    @Override
    public void handleEvent(Event event) throws Exception {
        AnalyticsConfigurationFactory analyticsConfigurationFactory = Scope.getCurrentScope().getSingleton(AnalyticsConfigurationFactory.class);
        LiquibaseRemoteAnalyticsConfiguration analyticsConfiguration = (LiquibaseRemoteAnalyticsConfiguration)analyticsConfigurationFactory.getPlugin();
        int timeoutMillis = analyticsConfiguration.getTimeoutMillis();
        Level logLevel = AnalyticsArgs.LOG_LEVEL.getCurrentValue();
        Logger logger = Scope.getCurrentScope().getLog(AnalyticsListener.class);
        LicenseService licenseService = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        String userId = ExceptionUtil.doSilently(() -> {
            String issuedTo = licenseService.getLicenseInfoObject().getIssuedTo();
            if (StringUtils.isNotEmpty((CharSequence)issuedTo)) {
                issuedTo = issuedTo + "-" + StringUtils.right((String)licenseService.getLicenseKey().getValue(), (int)AnalyticsArgs.LICENSE_KEY_CHARS.getCurrentValue());
            }
            return issuedTo;
        });
        AtomicBoolean timedOut = new AtomicBoolean(true);
        Thread eventThread = new Thread(() -> {
            try {
                URL url = new URL(analyticsConfiguration.getDestinationUrl());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json; utf-8");
                conn.setRequestProperty("Accept", "application/json");
                conn.setDoOutput(true);
                DumperOptions dumperOptions = new DumperOptions();
                dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
                dumperOptions.setWidth(Integer.MAX_VALUE);
                dumperOptions.setPrettyFlow(true);
                Yaml yaml = new Yaml(dumperOptions);
                yaml.setBeanAccess(BeanAccess.FIELD);
                AnalyticsBatch analyticsBatch = AnalyticsBatch.fromLiquibaseEvent(event, userId);
                String jsonInputString = YamlSerializer.removeClassTypeMarksFromSerializedJson(yaml.dumpAs((Object)analyticsBatch, Tag.MAP, DumperOptions.FlowStyle.FLOW));
                logger.log(logLevel, "Sending anonymous data to Liquibase analytics endpoint. " + System.lineSeparator() + jsonInputString, null);
                IOUtils.write((String)jsonInputString, (OutputStream)conn.getOutputStream(), (Charset)StandardCharsets.UTF_8);
                int responseCode = conn.getResponseCode();
                String responseBody = ExceptionUtil.doSilently(() -> IOUtils.toString((InputStream)conn.getInputStream()));
                logger.log(logLevel, "Response from Liquibase analytics endpoint: " + responseCode + " " + responseBody, null);
                conn.disconnect();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            timedOut.set(false);
        });
        eventThread.start();
        try {
            eventThread.join(timeoutMillis);
        }
        catch (InterruptedException e) {
            logger.log(logLevel, "Interrupted while waiting for analytics event processing.", e);
        }
        if (timedOut.get()) {
            logger.log(logLevel, "Timed out while waiting for analytics event processing.", null);
        }
    }

    @Generated
    public LiquibaseAnalyticsListener() {
    }
}

