/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.SearchTemplateQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class RepositorySearchTemplateQuery
extends AbstractElasticsearchRepositoryQuery {
    private String id;
    private Map<String, Object> params;

    public RepositorySearchTemplateQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations, ValueExpressionDelegate valueExpressionDelegate, String id) {
        super(queryMethod, elasticsearchOperations, valueExpressionDelegate.createValueContextProvider(queryMethod.getParameters()));
        Assert.hasLength((String)id, (String)"id must not be null or empty");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected BaseQuery createQuery(ElasticsearchParametersParameterAccessor parameterAccessor) {
        LinkedHashMap<String, Object> searchTemplateParameters = new LinkedHashMap<String, Object>();
        Object[] values = parameterAccessor.getValues();
        parameterAccessor.getParameters().forEach(parameter -> {
            if (!parameter.isSpecialParameter() && parameter.getName().isPresent() && parameter.getIndex() <= values.length) {
                searchTemplateParameters.put((String)parameter.getName().get(), values[parameter.getIndex()]);
            }
        });
        return SearchTemplateQuery.builder().withId(this.id).withParams(searchTemplateParameters).build();
    }
}

