/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

class ImageSize
extends CatchAllMultiParameterFunction {
    ImageSize() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        CssString filenameArg = (CssString)splitParameters.get(0);
        String filename = filenameArg.getValue();
        LessSource source = token.getSource();
        try {
            LessSource dataSource = source.relativeSource(filename);
            byte[] data = dataSource.getBytes();
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
            if (image == null) {
                problemsHandler.errorUnknownImageFileFormat(functionCall, filename);
                return new FaultyExpression(functionCall.getUnderlyingStructure());
            }
            int width = image.getWidth();
            int height = image.getHeight();
            return this.toSizeNumber(functionCall.getUnderlyingStructure(), width, height);
        }
        catch (LessSource.FileNotFound ex) {
            problemsHandler.errorFileNotFound(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
        catch (LessSource.CannotReadFile e) {
            problemsHandler.errorFileCanNotBeRead(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
        catch (IOException e) {
            problemsHandler.errorFileCanNotBeRead(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
        catch (LessSource.StringSourceException ex) {
            problemsHandler.errorFileReferenceNoBaseDirectory(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
    }

    protected Expression toSizeNumber(HiddenTokenAwareTree token, int width, int height) {
        Expression widthExp = this.toPixels(token, width);
        Expression heightExp = this.toPixels(token, height);
        return new ListExpression(token, Arrays.asList(widthExp, heightExp), new ListExpressionOperator(token, ListExpressionOperator.Operator.EMPTY_OPERATOR));
    }

    protected Expression toPixels(HiddenTokenAwareTree token, int width) {
        return new NumberExpression(token, Double.valueOf(width), "px", null, NumberExpression.Dimension.LENGTH);
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return 1;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.STRING_EXPRESSION);
    }

    @Override
    protected String getName() {
        return "image-size";
    }
}

