/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.websocket.listener;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.model.SpaceWebNotificationItemUpdate;
import org.exoplatform.social.websocket.SpaceWebNotificationWebSocketService;
import org.exoplatform.social.websocket.entity.WebSocketMessage;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class SpaceWebNotificationWebSocketServerListener
implements ServerChannel.MessageListener {
    private static final String SPACE_WEB_NOTIFICATION_ITEM_MAP_KEY = "spaceWebNotificationItem";
    private static final Log LOG = ExoLogger.getLogger(SpaceWebNotificationWebSocketServerListener.class);
    private PortalContainer container;
    private SpaceWebNotificationWebSocketService spaceWebNotificationWebSocketService;
    private String cometdChannel;

    public SpaceWebNotificationWebSocketServerListener(PortalContainer container, SpaceWebNotificationWebSocketService spaceWebNotificationWebSocketService, String cometdChannel) {
        this.container = container;
        this.spaceWebNotificationWebSocketService = spaceWebNotificationWebSocketService;
        this.cometdChannel = cometdChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
        if (message == null || message.getData() == null) {
            LOG.warn((Object)"Empty analytics WebSocket message is received");
            return false;
        }
        if (from == null) {
            LOG.warn((Object)"Empty analytics WebSocket session is received");
            return false;
        }
        if (channel == null) {
            LOG.warn((Object)"Empty WebSocket channel received");
            return false;
        }
        if (!StringUtils.equals((CharSequence)channel.getId(), (CharSequence)this.cometdChannel)) {
            LOG.debug("Not adequate channel name {}", new Object[]{channel.getId()});
            return false;
        }
        Object data = message.getData();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            WebSocketMessage webSocketMessage = this.fromJsonString(data.toString());
            SpaceWebNotificationItemUpdate spaceWebNotificationItem = (SpaceWebNotificationItemUpdate)webSocketMessage.getMessage().get(SPACE_WEB_NOTIFICATION_ITEM_MAP_KEY);
            this.spaceWebNotificationWebSocketService.receiveMessage(from.getId(), webSocketMessage.getWsEventName(), (SpaceWebNotificationItem)spaceWebNotificationItem);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Error marking as read", (Throwable)e);
            } else {
                LOG.warn("Error when parsing Web Socket message: {}", new Object[]{e.getMessage()});
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    private WebSocketMessage fromJsonString(String data) {
        try {
            JsonDefaultHandler wsMessageHandler = new JsonDefaultHandler();
            new JsonParserImpl().parse((InputStream)new ByteArrayInputStream(data.getBytes()), (JsonHandler)wsMessageHandler);
            String wsEventName = wsMessageHandler.getJsonObject().getElement("wsEventName").getStringValue();
            String notificationItemString = wsMessageHandler.getJsonObject().getElement("message").getElement(SPACE_WEB_NOTIFICATION_ITEM_MAP_KEY).getStringValue();
            JsonDefaultHandler notificationItemHandler = new JsonDefaultHandler();
            new JsonParserImpl().parse((InputStream)new ByteArrayInputStream(notificationItemString.getBytes()), (JsonHandler)notificationItemHandler);
            SpaceWebNotificationItemUpdate spaceWebNotificationItem = (SpaceWebNotificationItemUpdate)ObjectBuilder.createObject(SpaceWebNotificationItemUpdate.class, (JsonValue)notificationItemHandler.getJsonObject());
            return new WebSocketMessage(wsEventName, Collections.singletonMap(SPACE_WEB_NOTIFICATION_ITEM_MAP_KEY, spaceWebNotificationItem));
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error when parsing Web Socket message", e);
        }
    }
}

