/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

public final class DotName
implements Comparable<DotName> {
    static final DotName JAVA_NAME = new DotName(null, "java", true, false);
    static final DotName JAVA_LANG_NAME = new DotName(JAVA_NAME, "lang", true, false);
    static final DotName JAVA_LANG_ANNOTATION_NAME = new DotName(JAVA_LANG_NAME, "annotation", true, false);
    public static final DotName OBJECT_NAME = new DotName(JAVA_LANG_NAME, "Object", true, false);
    public static final DotName ENUM_NAME = new DotName(JAVA_LANG_NAME, "Enum", true, false);
    public static final DotName RECORD_NAME = new DotName(JAVA_LANG_NAME, "Record", true, false);
    public static final DotName STRING_NAME = new DotName(JAVA_LANG_NAME, "String", true, false);
    private final DotName prefix;
    private final String local;
    private int hash;
    private final boolean componentized;
    private final boolean innerClass;

    public static DotName createSimple(String name) {
        return new DotName(null, name, false, false);
    }

    public static DotName createSimple(Class<?> clazz) {
        return DotName.createSimple(clazz.getName());
    }

    public static DotName createComponentized(DotName prefix, String localName) {
        if (localName.indexOf(46) != -1) {
            throw new IllegalArgumentException("A componentized DotName must not contain '.' characters in a local name");
        }
        return new DotName(prefix, localName, true, false);
    }

    public static DotName createComponentized(DotName prefix, String localName, boolean innerClass) {
        if (localName.indexOf(46) != -1) {
            throw new IllegalArgumentException("A componentized DotName must not contain '.' characters in a local name");
        }
        return new DotName(prefix, localName, true, innerClass);
    }

    DotName(DotName prefix, String local, boolean noDots, boolean innerClass) {
        if (local == null) {
            throw new IllegalArgumentException("Local name must not be null");
        }
        if (prefix != null && !prefix.componentized) {
            throw new IllegalArgumentException("A componentized DotName must not have a non-componentized prefix");
        }
        this.prefix = prefix;
        this.local = local;
        this.componentized = noDots;
        this.innerClass = innerClass;
    }

    public DotName prefix() {
        return this.prefix;
    }

    public String local() {
        return this.local;
    }

    public String withoutPackagePrefix() {
        if (this.componentized) {
            StringBuilder builder = new StringBuilder();
            this.stripPackage(builder);
            return builder.toString();
        }
        int index = this.local.lastIndexOf(46);
        return index == -1 ? this.local : (index < this.local.length() - 1 ? this.local.substring(index + 1) : "");
    }

    private void stripPackage(StringBuilder builder) {
        if (this.innerClass) {
            this.prefix.stripPackage(builder);
            builder.append('$');
        }
        builder.append(this.local);
    }

    public String packagePrefix() {
        if (this.componentized) {
            if (this.prefix == null) {
                return null;
            }
            if (this.innerClass) {
                return this.prefix.packagePrefix();
            }
            return this.prefix.toString();
        }
        int index = this.local.lastIndexOf(46);
        return index == -1 ? null : this.local.substring(0, index);
    }

    public DotName packagePrefixName() {
        if (this.componentized) {
            if (this.prefix == null) {
                return null;
            }
            if (this.innerClass) {
                return this.prefix.packagePrefixName();
            }
            return this.prefix;
        }
        int index = this.local.lastIndexOf(46);
        return index == -1 ? null : DotName.createSimple(this.local.substring(0, index));
    }

    public boolean isComponentized() {
        return this.componentized;
    }

    public boolean isInner() {
        return this.innerClass;
    }

    public String toString() {
        return this.toString('.');
    }

    public String toString(char delim) {
        if (this.componentized) {
            StringBuilder builder = new StringBuilder();
            this.buildString(delim, builder);
            return builder.toString();
        }
        return delim == '.' ? this.local : this.local.replace('.', delim);
    }

    private void buildString(char delim, StringBuilder builder) {
        if (this.prefix != null) {
            this.prefix.buildString(delim, builder);
            builder.append(this.innerClass ? (char)'$' : (char)delim);
        }
        builder.append(this.local);
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        if (this.prefix != null) {
            hash = this.prefix.hashCode() * 31 + (this.innerClass ? 36 : 46);
            for (int i = 0; i < this.local.length(); ++i) {
                hash = 31 * hash + this.local.charAt(i);
            }
        } else {
            hash = this.local.hashCode();
        }
        this.hash = hash;
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DotName)) {
            return false;
        }
        DotName other = (DotName)o;
        if (this.prefix == null && other.prefix == null) {
            return this.local.equals(other.local) && this.innerClass == other.innerClass;
        }
        if (this.hash != 0 && other.hash != 0 && this.hash != other.hash) {
            return false;
        }
        return DotName.componentizedEquals(this, other);
    }

    private static boolean componentizedEquals(DotName a, DotName b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.innerClass == b.innerClass && a.local.equals(b.local)) {
            return DotName.componentizedEquals(a.prefix, b.prefix);
        }
        String aLocal = a.local;
        String bLocal = b.local;
        int aPos = aLocal.length() - 1;
        int bPos = bLocal.length() - 1;
        while (a != null && b != null) {
            int bChar;
            int aChar;
            int n = aPos >= 0 ? aLocal.charAt(aPos) : (aChar = a.innerClass ? 36 : 46);
            int n2 = bPos >= 0 ? bLocal.charAt(bPos) : (bChar = b.innerClass ? 36 : 46);
            if (aChar != bChar) {
                return false;
            }
            if (--aPos < -1 && (a = a.prefix) != null) {
                aLocal = a.local;
                aPos = aLocal.length() - 1;
            }
            if (--bPos >= -1 || (b = b.prefix) == null) continue;
            bLocal = b.local;
            bPos = bLocal.length() - 1;
        }
        return a == null && b == null;
    }

    @Override
    public int compareTo(DotName other) {
        if (this == other) {
            return 0;
        }
        if (this.prefix == null && other.prefix == null) {
            if (this.innerClass != other.innerClass) {
                return this.innerClass ? -1 : 1;
            }
            return this.local.compareTo(other.local);
        }
        return DotName.componentizedCompare(DotName.flatten(this), DotName.flatten(other));
    }

    private static int componentizedCompare(DotName[] a, DotName[] b) {
        int aPos = 0;
        DotName aCur = a[aPos];
        int bPos = 0;
        DotName bCur = b[bPos];
        while (aCur == bCur) {
            aCur = a[++aPos];
            bCur = b[++bPos];
        }
        String aCurLocal = null;
        int aCurLocalLength = 0;
        int aCharPos = -1;
        if (aCur != null) {
            aCurLocal = aCur.local;
            aCurLocalLength = aCurLocal.length();
        }
        String bCurLocal = null;
        int bCurLocalLength = 0;
        int bCharPos = -1;
        if (bCur != null) {
            bCurLocal = bCur.local;
            bCurLocalLength = bCurLocal.length();
        }
        while (aCur != null && bCur != null) {
            int bChar;
            int aChar;
            int n = aCharPos >= 0 ? aCurLocal.charAt(aCharPos) : (aChar = aCur.innerClass ? 36 : 46);
            int n2 = bCharPos >= 0 ? bCurLocal.charAt(bCharPos) : (bChar = bCur.innerClass ? 36 : 46);
            if (aChar != bChar) {
                return aChar - bChar;
            }
            if (++aCharPos == aCurLocalLength) {
                aCharPos = -1;
                if ((aCur = a[++aPos]) != null) {
                    aCurLocal = aCur.local;
                    aCurLocalLength = aCurLocal.length();
                }
            }
            if (++bCharPos != bCurLocalLength) continue;
            bCharPos = -1;
            if ((bCur = b[++bPos]) == null) continue;
            bCurLocal = bCur.local;
            bCurLocalLength = bCurLocal.length();
        }
        if (aCur == null && bCur == null) {
            return 0;
        }
        if (aCur != null) {
            return 1;
        }
        return -1;
    }

    private static DotName[] flatten(DotName name) {
        int count = 0;
        DotName tmp = name;
        while (tmp != null) {
            ++count;
            tmp = tmp.prefix;
        }
        DotName[] result = new DotName[count + 1];
        result[count] = null;
        DotName tmp2 = name;
        int index = count - 1;
        while (tmp2 != null) {
            result[index] = tmp2;
            --index;
            tmp2 = tmp2.prefix;
        }
        return result;
    }
}

