/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SequenceGenerators;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.TableGenerators;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.CollectionTypeRegistrations;
import org.hibernate.annotations.CompositeTypeRegistration;
import org.hibernate.annotations.CompositeTypeRegistrations;
import org.hibernate.annotations.ConverterRegistration;
import org.hibernate.annotations.ConverterRegistrations;
import org.hibernate.annotations.EmbeddableInstantiatorRegistration;
import org.hibernate.annotations.EmbeddableInstantiatorRegistrations;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.FetchProfiles;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.GenericGenerators;
import org.hibernate.annotations.Imported;
import org.hibernate.annotations.JavaTypeRegistration;
import org.hibernate.annotations.JavaTypeRegistrations;
import org.hibernate.annotations.JdbcTypeRegistration;
import org.hibernate.annotations.JdbcTypeRegistrations;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.TypeRegistration;
import org.hibernate.annotations.TypeRegistrations;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.FetchOverrideSecondPass;
import org.hibernate.boot.model.internal.FilterDefBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(MetadataBuildingContext context) {
        List storedProcedureQueries;
        List mappings;
        List nativeQueries;
        List queries;
        IdentifierGeneratorDefinition idGen;
        Map defaults = context.getBootstrapContext().getReflectionManager().getDefaults();
        List generators = (List)defaults.get(SequenceGenerator.class);
        if (generators != null) {
            for (SequenceGenerator sequenceGenerator : generators) {
                idGen = GeneratorBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
                if (idGen == null) continue;
                context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
            }
        }
        if ((generators = (List)defaults.get(TableGenerator.class)) != null) {
            for (TableGenerator tableGenerator : generators) {
                idGen = GeneratorBinder.buildIdGenerator((Annotation)tableGenerator, context);
                if (idGen == null) continue;
                context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
            }
        }
        if ((generators = (List)defaults.get(TableGenerators.class)) != null) {
            generators.forEach(tableGenerators -> {
                for (TableGenerator tableGenerator : tableGenerators.value()) {
                    IdentifierGeneratorDefinition idGen = GeneratorBinder.buildIdGenerator((Annotation)tableGenerator, context);
                    if (idGen == null) continue;
                    context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
                }
            });
        }
        if ((generators = (List)defaults.get(SequenceGenerators.class)) != null) {
            generators.forEach(sequenceGenerators -> {
                for (SequenceGenerator sequenceGenerator : sequenceGenerators.value()) {
                    IdentifierGeneratorDefinition idGen = GeneratorBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
                    if (idGen == null) continue;
                    context.getMetadataCollector().addDefaultIdentifierGenerator(idGen);
                }
            });
        }
        if ((queries = (List)defaults.get(NamedQuery.class)) != null) {
            for (NamedQuery ann : queries) {
                QueryBinder.bindQuery(ann, context, true);
            }
        }
        if ((nativeQueries = (List)defaults.get(jakarta.persistence.NamedNativeQuery.class)) != null) {
            for (NamedQuery ann : nativeQueries) {
                QueryBinder.bindNativeQuery((jakarta.persistence.NamedNativeQuery)ann, context, true);
            }
        }
        if ((mappings = (List)defaults.get(SqlResultSetMapping.class)) != null) {
            for (SqlResultSetMapping annotation : mappings) {
                QueryBinder.bindSqlResultSetMapping(annotation, context, true);
            }
        }
        if ((storedProcedureQueries = (List)defaults.get(NamedStoredProcedureQuery.class)) != null) {
            for (SqlResultSetMapping annotation : storedProcedureQueries) {
                AnnotationBinder.bindNamedStoredProcedureQuery((NamedStoredProcedureQuery)annotation, context, true);
            }
        }
        if ((storedProcedureQueries = (List)defaults.get(NamedStoredProcedureQueries.class)) != null) {
            for (SqlResultSetMapping annotation : storedProcedureQueries) {
                AnnotationBinder.bindNamedStoredProcedureQueries((NamedStoredProcedureQueries)annotation, context, true);
            }
        }
    }

    public static void bindPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package pack = cls.packageForNameOrNull(packageName);
        if (pack == null) {
            return;
        }
        XPackage annotatedPackage = context.getBootstrapContext().getReflectionManager().toXPackage(pack);
        AnnotationBinder.handleIdGenerators(annotatedPackage, context);
        AnnotationBinder.bindTypeDescriptorRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindUserTypeRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindConverterRegistrations((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindGenericGenerators((XAnnotatedElement)annotatedPackage, context);
        AnnotationBinder.bindQueries((XAnnotatedElement)annotatedPackage, context);
        FilterDefBinder.bindFilterDefs((XAnnotatedElement)annotatedPackage, context);
    }

    private static void handleIdGenerators(XPackage annotatedPackage, MetadataBuildingContext context) {
        Object idGen;
        if (annotatedPackage.isAnnotationPresent(SequenceGenerator.class)) {
            SequenceGenerator sequenceGenerator = (SequenceGenerator)annotatedPackage.getAnnotation(SequenceGenerator.class);
            idGen = GeneratorBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
            context.getMetadataCollector().addIdentifierGenerator((IdentifierGeneratorDefinition)idGen);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", ((IdentifierGeneratorDefinition)idGen).getName());
            }
        }
        if (annotatedPackage.isAnnotationPresent(SequenceGenerators.class)) {
            SequenceGenerators sequenceGenerators = (SequenceGenerators)annotatedPackage.getAnnotation(SequenceGenerators.class);
            for (SequenceGenerator sequenceGenerator : sequenceGenerators.value()) {
                context.getMetadataCollector().addIdentifierGenerator(GeneratorBinder.buildIdGenerator((Annotation)sequenceGenerator, context));
            }
        }
        if (annotatedPackage.isAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableGenerator = (TableGenerator)annotatedPackage.getAnnotation(TableGenerator.class);
            idGen = GeneratorBinder.buildIdGenerator((Annotation)tableGenerator, context);
            context.getMetadataCollector().addIdentifierGenerator((IdentifierGeneratorDefinition)idGen);
        }
        if (annotatedPackage.isAnnotationPresent(TableGenerators.class)) {
            TableGenerators tableGenerators = (TableGenerators)annotatedPackage.getAnnotation(TableGenerators.class);
            for (TableGenerator tableGenerator : tableGenerators.value()) {
                context.getMetadataCollector().addIdentifierGenerator(GeneratorBinder.buildIdGenerator((Annotation)tableGenerator, context));
            }
        }
    }

    private static void bindGenericGenerators(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        GenericGenerator genericGenerator = (GenericGenerator)annotatedElement.getAnnotation(GenericGenerator.class);
        GenericGenerators genericGenerators = (GenericGenerators)annotatedElement.getAnnotation(GenericGenerators.class);
        if (genericGenerator != null) {
            AnnotationBinder.bindGenericGenerator(genericGenerator, context);
        }
        if (genericGenerators != null) {
            for (GenericGenerator generator : genericGenerators.value()) {
                AnnotationBinder.bindGenericGenerator(generator, context);
            }
        }
    }

    private static void bindGenericGenerator(GenericGenerator def, MetadataBuildingContext context) {
        context.getMetadataCollector().addIdentifierGenerator(GeneratorBinder.buildIdGenerator(def, context));
    }

    private static void bindNamedJpaQueries(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        QueryBinder.bindSqlResultSetMapping((SqlResultSetMapping)annotatedElement.getAnnotation(SqlResultSetMapping.class), context, false);
        QueryBinder.bindSqlResultSetMappings((SqlResultSetMappings)annotatedElement.getAnnotation(SqlResultSetMappings.class), context, false);
        QueryBinder.bindQuery((NamedQuery)annotatedElement.getAnnotation(NamedQuery.class), context, false);
        QueryBinder.bindQueries((jakarta.persistence.NamedQueries)annotatedElement.getAnnotation(jakarta.persistence.NamedQueries.class), context, false);
        QueryBinder.bindNativeQuery((jakarta.persistence.NamedNativeQuery)annotatedElement.getAnnotation(jakarta.persistence.NamedNativeQuery.class), context, false);
        QueryBinder.bindNativeQueries((jakarta.persistence.NamedNativeQueries)annotatedElement.getAnnotation(jakarta.persistence.NamedNativeQueries.class), context, false);
    }

    public static void bindQueries(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        AnnotationBinder.bindNamedJpaQueries(annotatedElement, context);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)annotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class), context);
        QueryBinder.bindQueries((NamedQueries)annotatedElement.getAnnotation(NamedQueries.class), context);
        QueryBinder.bindNativeQuery((NamedNativeQuery)annotatedElement.getAnnotation(NamedNativeQuery.class), context);
        QueryBinder.bindNativeQueries((NamedNativeQueries)annotatedElement.getAnnotation(NamedNativeQueries.class), context);
        AnnotationBinder.bindNamedStoredProcedureQuery((NamedStoredProcedureQuery)annotatedElement.getAnnotation(NamedStoredProcedureQuery.class), context, false);
        AnnotationBinder.bindNamedStoredProcedureQueries((NamedStoredProcedureQueries)annotatedElement.getAnnotation(NamedStoredProcedureQueries.class), context, false);
    }

    private static void bindNamedStoredProcedureQueries(NamedStoredProcedureQueries annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation != null) {
            for (NamedStoredProcedureQuery queryAnnotation : annotation.value()) {
                AnnotationBinder.bindNamedStoredProcedureQuery(queryAnnotation, context, isDefault);
            }
        }
    }

    private static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation != null) {
            QueryBinder.bindNamedStoredProcedureQuery(annotation, context, isDefault);
        }
    }

    public static void bindClass(XClass annotatedClass, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) throws MappingException {
        AnnotationBinder.detectMappedSuperclassProblems(annotatedClass);
        AnnotationBinder.bindQueries((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.handleImport(annotatedClass, context);
        FilterDefBinder.bindFilterDefs((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindTypeDescriptorRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindUserTypeRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((XAnnotatedElement)annotatedClass, context);
        AnnotationBinder.bindConverterRegistrations((XAnnotatedElement)annotatedClass, context);
        Map<String, IdentifierGeneratorDefinition> generators = GeneratorBinder.buildGenerators((XAnnotatedElement)annotatedClass, context);
        if (context.getMetadataCollector().getClassType(annotatedClass) == AnnotatedClassType.ENTITY) {
            EntityBinder.bindEntityClass(annotatedClass, inheritanceStatePerClass, generators, context);
        }
    }

    private static void handleImport(XClass annotatedClass, MetadataBuildingContext context) {
        if (annotatedClass.isAnnotationPresent(Imported.class)) {
            String qualifiedName = annotatedClass.getName();
            String name = StringHelper.unqualify(qualifiedName);
            String rename = ((Imported)annotatedClass.getAnnotation(Imported.class)).rename();
            context.getMetadataCollector().addImport(rename.isEmpty() ? name : rename, qualifiedName);
        }
    }

    private static void detectMappedSuperclassProblems(XClass annotatedClass) {
        if (annotatedClass.isAnnotationPresent(MappedSuperclass.class)) {
            if (annotatedClass.isAnnotationPresent(Entity.class)) {
                throw new AnnotationException("Type '" + annotatedClass.getName() + "' is annotated both '@Entity' and '@MappedSuperclass'");
            }
            if (annotatedClass.isAnnotationPresent(Table.class)) {
                throw new AnnotationException("Mapped superclass '" + annotatedClass.getName() + "' may not specify a '@Table'");
            }
            if (annotatedClass.isAnnotationPresent(Inheritance.class)) {
                throw new AnnotationException("Mapped superclass '" + annotatedClass.getName() + "' may not specify an '@Inheritance' mapping strategy");
            }
        }
    }

    private static void bindTypeDescriptorRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        CollectionTypeRegistrations collectionTypeRegistrations;
        ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JavaTypeRegistration javaTypeRegistration = (JavaTypeRegistration)annotatedElement.getAnnotation(JavaTypeRegistration.class);
        if (javaTypeRegistration != null) {
            AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, javaTypeRegistration);
        } else {
            JavaTypeRegistrations javaTypeRegistrations = (JavaTypeRegistrations)annotatedElement.getAnnotation(JavaTypeRegistrations.class);
            if (javaTypeRegistrations != null) {
                for (JavaTypeRegistration registration : javaTypeRegistrations.value()) {
                    AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, registration);
                }
            }
        }
        JdbcTypeRegistration jdbcTypeRegistration = (JdbcTypeRegistration)annotatedElement.getAnnotation(JdbcTypeRegistration.class);
        if (jdbcTypeRegistration != null) {
            AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, jdbcTypeRegistration);
        } else {
            JdbcTypeRegistrations jdbcTypeRegistrations = (JdbcTypeRegistrations)annotatedElement.getAnnotation(JdbcTypeRegistrations.class);
            if (jdbcTypeRegistrations != null) {
                for (JdbcTypeRegistration registration : jdbcTypeRegistrations.value()) {
                    AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, registration);
                }
            }
        }
        CollectionTypeRegistration collectionTypeRegistration = (CollectionTypeRegistration)annotatedElement.getAnnotation(CollectionTypeRegistration.class);
        if (collectionTypeRegistration != null) {
            context.getMetadataCollector().addCollectionTypeRegistration(collectionTypeRegistration);
        }
        if ((collectionTypeRegistrations = (CollectionTypeRegistrations)annotatedElement.getAnnotation(CollectionTypeRegistrations.class)) != null) {
            for (CollectionTypeRegistration registration : collectionTypeRegistrations.value()) {
                context.getMetadataCollector().addCollectionTypeRegistration(registration);
            }
        }
    }

    private static void handleJdbcTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JdbcTypeRegistration annotation) {
        Class<? extends JdbcType> jdbcTypeClass = annotation.value();
        JdbcType jdbcType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass) : managedBeanRegistry.getBean(jdbcTypeClass).getBeanInstance();
        int typeCode = annotation.registrationCode() == Integer.MIN_VALUE ? jdbcType.getDefaultSqlTypeCode() : annotation.registrationCode();
        context.getMetadataCollector().addJdbcTypeRegistration(typeCode, jdbcType);
    }

    private static void handleJavaTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JavaTypeRegistration annotation) {
        Class<? extends BasicJavaType<?>> javaTypeClass = annotation.descriptorClass();
        BasicJavaType<?> javaType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass) : managedBeanRegistry.getBean(javaTypeClass).getBeanInstance();
        context.getMetadataCollector().addJavaTypeRegistration(annotation.javaType(), javaType);
    }

    private static void bindEmbeddableInstantiatorRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        EmbeddableInstantiatorRegistration embeddableInstantiatorRegistration = (EmbeddableInstantiatorRegistration)annotatedElement.getAnnotation(EmbeddableInstantiatorRegistration.class);
        if (embeddableInstantiatorRegistration != null) {
            AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, embeddableInstantiatorRegistration);
        } else {
            EmbeddableInstantiatorRegistrations embeddableInstantiatorRegistrations = (EmbeddableInstantiatorRegistrations)annotatedElement.getAnnotation(EmbeddableInstantiatorRegistrations.class);
            if (embeddableInstantiatorRegistrations != null) {
                for (EmbeddableInstantiatorRegistration registration : embeddableInstantiatorRegistrations.value()) {
                    AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, registration);
                }
            }
        }
    }

    private static void handleEmbeddableInstantiatorRegistration(MetadataBuildingContext context, EmbeddableInstantiatorRegistration annotation) {
        context.getMetadataCollector().registerEmbeddableInstantiator(annotation.embeddableClass(), annotation.instantiator());
    }

    private static void bindCompositeUserTypeRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        CompositeTypeRegistration compositeTypeRegistration = (CompositeTypeRegistration)annotatedElement.getAnnotation(CompositeTypeRegistration.class);
        if (compositeTypeRegistration != null) {
            AnnotationBinder.handleCompositeUserTypeRegistration(context, compositeTypeRegistration);
        } else {
            CompositeTypeRegistrations compositeTypeRegistrations = (CompositeTypeRegistrations)annotatedElement.getAnnotation(CompositeTypeRegistrations.class);
            if (compositeTypeRegistrations != null) {
                for (CompositeTypeRegistration registration : compositeTypeRegistrations.value()) {
                    AnnotationBinder.handleCompositeUserTypeRegistration(context, registration);
                }
            }
        }
    }

    private static void bindUserTypeRegistrations(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        TypeRegistration typeRegistration = (TypeRegistration)annotatedElement.getAnnotation(TypeRegistration.class);
        if (typeRegistration != null) {
            AnnotationBinder.handleUserTypeRegistration(context, typeRegistration);
        } else {
            TypeRegistrations typeRegistrations = (TypeRegistrations)annotatedElement.getAnnotation(TypeRegistrations.class);
            if (typeRegistrations != null) {
                for (TypeRegistration registration : typeRegistrations.value()) {
                    AnnotationBinder.handleUserTypeRegistration(context, registration);
                }
            }
        }
    }

    private static void handleUserTypeRegistration(MetadataBuildingContext context, TypeRegistration compositeTypeRegistration) {
        context.getMetadataCollector().registerUserType(compositeTypeRegistration.basicClass(), compositeTypeRegistration.userType());
    }

    private static void handleCompositeUserTypeRegistration(MetadataBuildingContext context, CompositeTypeRegistration compositeTypeRegistration) {
        context.getMetadataCollector().registerCompositeUserType(compositeTypeRegistration.embeddableClass(), compositeTypeRegistration.userType());
    }

    private static void bindConverterRegistrations(XAnnotatedElement container, MetadataBuildingContext context) {
        ConverterRegistration converterRegistration = (ConverterRegistration)container.getAnnotation(ConverterRegistration.class);
        if (converterRegistration != null) {
            AnnotationBinder.handleConverterRegistration(converterRegistration, context);
        } else {
            ConverterRegistrations converterRegistrations = (ConverterRegistrations)container.getAnnotation(ConverterRegistrations.class);
            if (converterRegistrations != null) {
                for (ConverterRegistration registration : converterRegistrations.value()) {
                    AnnotationBinder.handleConverterRegistration(registration, context);
                }
            }
        }
    }

    private static void handleConverterRegistration(ConverterRegistration registration, MetadataBuildingContext context) {
        context.getMetadataCollector().getConverterRegistry().addRegisteredConversion(new RegisteredConversion(registration.domainType(), registration.converter(), registration.autoApply(), context));
    }

    public static void bindFetchProfilesForClass(XClass annotatedClass, MetadataBuildingContext context) {
        AnnotationBinder.bindFetchProfiles((XAnnotatedElement)annotatedClass, context);
    }

    public static void bindFetchProfilesForPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package pack = cls.packageForNameOrNull(packageName);
        if (pack != null) {
            ReflectionManager reflectionManager = context.getBootstrapContext().getReflectionManager();
            AnnotationBinder.bindFetchProfiles((XAnnotatedElement)reflectionManager.toXPackage(pack), context);
        }
    }

    private static void bindFetchProfiles(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        FetchProfile fetchProfile = (FetchProfile)annotatedElement.getAnnotation(FetchProfile.class);
        FetchProfiles fetchProfiles = (FetchProfiles)annotatedElement.getAnnotation(FetchProfiles.class);
        if (fetchProfile != null) {
            AnnotationBinder.bindFetchProfile(fetchProfile, context);
        }
        if (fetchProfiles != null) {
            for (FetchProfile profile : fetchProfiles.value()) {
                AnnotationBinder.bindFetchProfile(profile, context);
            }
        }
    }

    private static void bindFetchProfile(FetchProfile fetchProfile, MetadataBuildingContext context) {
        String name = fetchProfile.name();
        if (AnnotationBinder.reuseOrCreateFetchProfile(context, name)) {
            for (FetchProfile.FetchOverride fetch : fetchProfile.fetchOverrides()) {
                if (fetch.fetch() == FetchType.LAZY && fetch.mode() == FetchMode.JOIN) {
                    throw new AnnotationException("Fetch profile '" + name + "' has a '@FetchOverride' with 'fetch=LAZY' and 'mode=JOIN' (join fetching is eager by nature)");
                }
                context.getMetadataCollector().addSecondPass(new FetchOverrideSecondPass(name, fetch, context));
            }
        }
    }

    private static boolean reuseOrCreateFetchProfile(MetadataBuildingContext context, String name) {
        org.hibernate.mapping.FetchProfile existing = context.getMetadataCollector().getFetchProfile(name);
        if (existing == null) {
            org.hibernate.mapping.FetchProfile profile = new org.hibernate.mapping.FetchProfile(name, MetadataSource.ANNOTATIONS);
            context.getMetadataCollector().addFetchProfile(profile);
            return true;
        }
        return existing.getSource() == MetadataSource.ANNOTATIONS;
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses, MetadataBuildingContext buildingContext) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, buildingContext);
            if (superclassState != null) {
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                AnnotationBinder.logMixedInheritance(clazz, superclassState, state);
                if (superclassState.getType() != null) {
                    state.setType(superclassState.getType());
                }
            }
            switch (buildingContext.getMetadataCollector().getClassType(clazz)) {
                case ENTITY: 
                case MAPPED_SUPERCLASS: 
                case EMBEDDABLE: {
                    inheritanceStatePerClass.put(clazz, state);
                }
            }
        }
        return inheritanceStatePerClass;
    }

    private static void logMixedInheritance(XClass clazz, InheritanceState superclassState, InheritanceState state) {
        if (state.getType() != null && superclassState.getType() != null) {
            boolean mixingStrategy;
            boolean nonDefault = InheritanceType.SINGLE_TABLE != state.getType();
            boolean bl = mixingStrategy = state.getType() != superclassState.getType();
            if (nonDefault && mixingStrategy) {
                throw new AnnotationException("Entity '" + clazz.getName() + "' may not override the inheritance mapping strategy '" + superclassState.getType() + "' of its hierarchy' (each entity hierarchy has a single inheritance mapping strategy)");
            }
        }
    }
}

