/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.serialization.api.factory.DefaultObjectFactory;
import org.exoplatform.commons.serialization.api.factory.ObjectFactory;
import org.exoplatform.commons.serialization.model.TypeDomain;
import org.exoplatform.commons.serialization.serial.ObjectReader;
import org.exoplatform.commons.serialization.serial.ObjectWriter;

public class SerializationContext {
    private final TypeDomain typeDomain;
    private final Map<Class<?>, ObjectFactory<?>> factories;

    public SerializationContext(TypeDomain typeDomain) {
        HashMap factories = new HashMap();
        factories.put(Object.class, new DefaultObjectFactory());
        this.typeDomain = typeDomain;
        this.factories = factories;
    }

    public <O> void addFactory(ObjectFactory<O> factory) {
        Class<?> factoryClass = factory.getClass();
        ParameterizedType pt = (ParameterizedType)factoryClass.getGenericSuperclass();
        Class objectType = (Class)pt.getActualTypeArguments()[0];
        this.factories.put(objectType, factory);
    }

    public TypeDomain getTypeDomain() {
        return this.typeDomain;
    }

    public <O> ObjectFactory<? super O> getFactory(Class<O> type) {
        ObjectFactory<?> factory = this.factories.get(type);
        if (factory == null) {
            return this.getFactory(type.getSuperclass());
        }
        return factory;
    }

    public <O> O clone(O o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectWriter writer = new ObjectWriter(this, baos);
        writer.writeObject(o);
        writer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectReader in = new ObjectReader(this, bais);
        return (O)in.readObject();
    }

    public void write(Object o, OutputStream out) throws IOException {
        ObjectWriter writer = new ObjectWriter(this, out);
        writer.writeObject(o);
        writer.flush();
    }

    public byte[] write(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectWriter writer = new ObjectWriter(this, baos);
        writer.writeObject(o);
        writer.close();
        return baos.toByteArray();
    }

    public Object read(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectReader in = new ObjectReader(this, bais);
        return in.readObject();
    }

    public Object read(InputStream in) throws IOException, ClassNotFoundException {
        ObjectReader or = new ObjectReader(this, in);
        return or.readObject();
    }
}

