/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityCommentPlugin
extends BaseNotificationPlugin {
    public static final String ID = "ActivityCommentPlugin";
    protected boolean isSubComment = false;

    public ActivityCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        boolean subComment = this.isSubComment;
        List<String> receiversList = this.getNotificationReceivers(activity, comment, subComment);
        String poster = Utils.getUserId(comment.getUserId());
        return NotificationInfo.instance().to(receiversList).setFrom(poster).setSpaceId(activity.getSpaceId() == null ? 0L : Long.parseLong(activity.getSpaceId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.COMMENT_ID.getKey(), comment.getId()).with(SocialNotificationUtils.POSTER.getKey(), poster).key(this.getId());
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        if (!Utils.getActivityManager().isNotificationEnabled(comment) || this.isSubComment && comment.getParentCommentId() == null) {
            return false;
        }
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateSpaceIdentity(activity.getStreamOwner());
        return spaceIdentity == null || !activity.getPosterId().equals(spaceIdentity.getId());
    }

    protected List<String> getNotificationReceivers(ExoSocialActivity activity, ExoSocialActivity comment, boolean subComment) {
        String spaceId = activity.getSpaceId();
        HashSet<String> receivers = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)comment.getParentCommentId())) {
            ExoSocialActivity parentComment = Utils.getActivityManager().getActivity(comment.getParentCommentId());
            String parentCommentUserPosterId = Utils.getUserId(parentComment.getPosterId());
            if (subComment) {
                Utils.sendToActivityPoster(receivers, parentComment.getPosterId(), comment.getPosterId(), spaceId);
            } else {
                Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId(), spaceId);
                Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
                Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId(), spaceId);
                receivers.remove(parentCommentUserPosterId);
                receivers.remove(Utils.getUserId(comment.getPosterId()));
            }
        } else {
            Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId(), spaceId);
            Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
            Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId(), spaceId);
            receivers.remove(Utils.getUserId(comment.getPosterId()));
        }
        return receivers.stream().filter(username -> Utils.getActivityManager().isNotificationEnabled(comment, username)).toList();
    }
}

