/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ActivityIterator
implements Collection<ExoSocialActivity> {
    private final long offset;
    private final long limit;
    private final long totalSize;
    private long skip;
    private String[] ids;
    private List<ExoSocialActivity> gotList = null;

    public ActivityIterator(long offset, long limit, long totalSize) {
        this.offset = offset;
        this.limit = limit;
        this.totalSize = totalSize;
        this.ids = new String[0];
        this.gotList = new ArrayList<ExoSocialActivity>();
        this.skip = 0L;
    }

    @Override
    public int size() {
        return this.gotList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.gotList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof ExoSocialActivity) {
            ExoSocialActivity a = (ExoSocialActivity)o;
            return ArrayUtils.indexOf((Object[])this.ids, (Object)a.getId()) >= 0;
        }
        return false;
    }

    public boolean addMore() {
        return (long)this.gotList.size() < this.limit && (long)this.gotList.size() < this.totalSize;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public Iterator<ExoSocialActivity> iterator() {
        return this.gotList.iterator();
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public boolean add(ExoSocialActivity e) {
        if (this.contains(e)) {
            return false;
        }
        if (this.skip++ < this.offset) {
            return false;
        }
        this.ids = (String[])ArrayUtils.add((Object[])this.ids, (Object)e.getId());
        this.gotList.add(e);
        return true;
    }

    public List<ExoSocialActivity> result() {
        return this.gotList;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof ExoSocialActivity) {
            ExoSocialActivity a = (ExoSocialActivity)o;
            this.ids = (String[])ArrayUtils.removeElement((Object[])this.ids, (Object)a.getId());
            return this.gotList.remove(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends ExoSocialActivity> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.ids = new String[0];
        this.gotList = new ArrayList<ExoSocialActivity>();
    }
}

