/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.exec.spi.ExecutionContext;

public class InPredicateRestrictionProducer
implements MatchingIdRestrictionProducer {
    @Override
    public List<Expression> produceIdExpressionList(List<Object> idsAndFks, EntityMappingType entityDescriptor) {
        ArrayList<Expression> inListExpressions = new ArrayList<Expression>(idsAndFks.size());
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        if (identifierMapping instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicValuedModelPart = (BasicValuedModelPart)((Object)identifierMapping);
            for (int i = 0; i < idsAndFks.size(); ++i) {
                inListExpressions.add(new QueryLiteral<Object>(idsAndFks.get(i), basicValuedModelPart));
            }
        } else {
            int jdbcTypeCount = identifierMapping.getJdbcTypeCount();
            for (int i = 0; i < idsAndFks.size(); ++i) {
                Object[] id = (Object[])idsAndFks.get(i);
                ArrayList tupleElements = new ArrayList(jdbcTypeCount);
                inListExpressions.add(new SqlTuple(tupleElements, identifierMapping));
                identifierMapping.forEachJdbcType((index, jdbcMapping) -> tupleElements.add(new QueryLiteral<Object>(id[index], (BasicValuedMapping)((Object)jdbcMapping))));
            }
        }
        return inListExpressions;
    }

    @Override
    public InListPredicate produceRestriction(List<Expression> matchingIdValueExpressions, EntityMappingType entityDescriptor, int valueIndex, ModelPart valueModelPart, TableReference mutatingTableReference, Supplier<Consumer<SelectableConsumer>> columnsToMatchVisitationSupplier, ExecutionContext executionContext) {
        InListPredicate predicate;
        assert (matchingIdValueExpressions != null);
        assert (!matchingIdValueExpressions.isEmpty());
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        int idColumnCount = identifierMapping.getJdbcTypeCount();
        assert (idColumnCount > 0);
        if (idColumnCount == 1) {
            BasicValuedModelPart basicIdMapping = NullnessUtil.castNonNull(identifierMapping.asBasicValuedModelPart());
            String idColumn = basicIdMapping.getSelectionExpression();
            ColumnReference inFixture = new ColumnReference(mutatingTableReference, idColumn, false, null, basicIdMapping.getJdbcMapping());
            predicate = new InListPredicate((Expression)inFixture, matchingIdValueExpressions);
        } else {
            ArrayList columnReferences = new ArrayList(idColumnCount);
            SelectableConsumer selectableConsumer = (columnIndex, selection) -> columnReferences.add(new ColumnReference(mutatingTableReference, selection));
            if (columnsToMatchVisitationSupplier == null) {
                identifierMapping.forEachSelectable(selectableConsumer);
            } else {
                columnsToMatchVisitationSupplier.get().accept(selectableConsumer);
            }
            SqlTuple inFixture = new SqlTuple(columnReferences, identifierMapping);
            predicate = new InListPredicate((Expression)inFixture, matchingIdValueExpressions);
        }
        return predicate;
    }
}

