/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.DelegatingJsonpMapper;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.json.WithJson;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonParser;

public abstract class WithJsonObjectBuilderBase<B>
extends ObjectBuilderBase
implements WithJson<B> {
    protected abstract B self();

    @Override
    public B withJson(JsonParser parser, JsonpMapper mapper) {
        JsonpDeserializer<?> classDeser = JsonpMapperBase.findDeserializer(this.getClass().getEnclosingClass());
        if (classDeser == null) {
            throw new IllegalArgumentException("Class " + this.getClass().getEnclosingClass() + " cannot be read from JSON");
        }
        mapper = new WithJsonMapper(mapper);
        ObjectDeserializer builderDeser = (ObjectDeserializer)DelegatingDeserializer.unwrap(classDeser);
        builderDeser.deserialize(this.self(), parser, mapper, parser.next());
        return this.self();
    }

    private static class WithJsonMapper
    extends DelegatingJsonpMapper {
        WithJsonMapper(JsonpMapper parent) {
            super(parent);
        }

        @Override
        public <T> T attribute(String name) {
            Object attr = this.mapper.attribute(name);
            if (attr == null && name.startsWith("co.elastic.clients:Deserializer")) {
                JsonpDeserializer<JsonData> result = JsonData._DESERIALIZER;
                return (T)result;
            }
            return attr;
        }

        @Override
        public <T> JsonpMapper withAttribute(String name, T value) {
            return new WithJsonMapper(this.mapper.withAttribute(name, value));
        }
    }
}

