/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.common;

import java.net.HttpCookie;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class CookieParser {
    private CookieParser() {
    }

    public static List<HttpCookie> parse(String header) throws ParseException {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        State state = State.NAME;
        String name = null;
        int begin = 0;
        boolean quoted = false;
        block9: for (int end = 0; end < header.length(); ++end) {
            char ch = header.charAt(end);
            switch (state) {
                case NAME: {
                    if (ch == '$') {
                        state = State.SEPARATOR;
                        continue block9;
                    }
                    if (ch != '=') continue block9;
                    name = header.substring(begin, end).trim();
                    if (name.length() == 0) {
                        throw new ParseException(header, end);
                    }
                    state = State.VALUE;
                    begin = end + 1;
                    continue block9;
                }
                case VALUE: {
                    String value;
                    if (Character.isWhitespace(ch) && begin == end) {
                        begin = end + 1;
                        continue block9;
                    }
                    switch (ch) {
                        case '\"': {
                            if (quoted) {
                                value = header.substring(begin, end).trim();
                                cookies.add(new HttpCookie(name, value));
                                state = State.SEPARATOR;
                                name = null;
                                quoted = false;
                                continue block9;
                            }
                            quoted = true;
                            begin = end + 1;
                            continue block9;
                        }
                        case ';': {
                            if (quoted) continue block9;
                            value = header.substring(begin, end).trim();
                            cookies.add(new HttpCookie(name, value));
                            state = State.NAME;
                            name = null;
                            begin = end + 1;
                            continue block9;
                        }
                    }
                    if (end + 1 != header.length()) continue block9;
                    if (quoted) {
                        throw new ParseException(header, begin);
                    }
                    value = header.substring(begin, end + 1).trim();
                    cookies.add(new HttpCookie(name, value));
                    continue block9;
                }
                case SEPARATOR: {
                    if (ch != ';') continue block9;
                    state = State.NAME;
                    name = null;
                    begin = end + 1;
                }
            }
        }
        return cookies;
    }

    private static enum State {
        NAME,
        VALUE,
        SEPARATOR;

    }
}

