/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import lombok.Generated;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskChangeLog")
@Table(name="TASK_CHANGE_LOGS")
@NamedQueries(value={@NamedQuery(name="TaskChangeLog.findChangeLogByTaskId", query="SELECT log FROM TaskChangeLog log WHERE log.task.id = :taskId ORDER BY log.createdTime DESC"), @NamedQuery(name="TaskChangeLog.countChangeLogByTaskId", query="SELECT count(log) FROM TaskChangeLog log WHERE log.task.id = :taskId"), @NamedQuery(name="TaskChangeLog.removeChangeLogByTaskId", query="DELETE FROM TaskChangeLog log WHERE log.task.id = :taskId")})
public class ChangeLog
implements Comparable<ChangeLog> {
    @Id
    @SequenceGenerator(name="SEQ_TASK_CHANGE_LOG_ID", sequenceName="SEQ_TASK_CHANGE_LOG_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_CHANGE_LOG_ID")
    @Column(name="CHANGE_LOG_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="TASK_ID")
    private Task task;
    private String author;
    @Column(name="ACTION_NAME")
    private String actionName;
    private String target;
    @Column(name="CREATED_TIME")
    private long createdTime = System.currentTimeMillis();

    @Override
    public int compareTo(ChangeLog o) {
        return (int)(this.getCreatedTime() - o.getCreatedTime());
    }

    public ChangeLog clone() {
        ChangeLog log = new ChangeLog();
        log.setId(this.getId());
        log.setTask(this.getTask().clone());
        log.setAuthor(this.getAuthor());
        log.setActionName(this.getActionName());
        log.setCreatedTime(this.getCreatedTime());
        log.setTarget(this.getTarget());
        return log;
    }

    @Generated
    public ChangeLog() {
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getActionName() {
        return this.actionName;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setTask(Task task) {
        this.task = task;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Generated
    public void setTarget(String target) {
        this.target = target;
    }

    @Generated
    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeLog)) {
            return false;
        }
        ChangeLog other = (ChangeLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getCreatedTime() != other.getCreatedTime()) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$actionName = this.getActionName();
        String other$actionName = other.getActionName();
        if (this$actionName == null ? other$actionName != null : !this$actionName.equals(other$actionName)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeLog;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $createdTime = this.getCreatedTime();
        result = result * 59 + (int)($createdTime >>> 32 ^ $createdTime);
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $actionName = this.getActionName();
        result = result * 59 + ($actionName == null ? 43 : $actionName.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChangeLog(id=" + this.getId() + ", task=" + String.valueOf(this.getTask()) + ", author=" + this.getAuthor() + ", actionName=" + this.getActionName() + ", target=" + this.getTarget() + ", createdTime=" + this.getCreatedTime() + ")";
    }
}

