/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;

@Managed
@NameTemplate(value={@Property(key="service", value="cache"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Exo Cache")
public interface ExoCache<K extends Serializable, V> {
    @Managed
    @ManagedName(value="Name")
    @ManagedDescription(value="The cache name")
    public String getName();

    public void setName(String var1);

    public String getLabel();

    public void setLabel(String var1);

    public V get(Serializable var1);

    public V remove(Serializable var1) throws NullPointerException;

    default public void removeLocal(Serializable key) throws NullPointerException {
        this.remove(key);
    }

    public void put(K var1, V var2) throws NullPointerException;

    default public void putLocal(K key, V value) throws NullPointerException {
        this.put(key, value);
    }

    public void putMap(Map<? extends K, ? extends V> var1) throws NullPointerException, IllegalArgumentException;

    default public void putAsyncMap(Map<? extends K, ? extends V> objs) throws NullPointerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Managed
    @ManagedDescription(value="Evict all entries of the cache")
    public void clearCache();

    public void select(CachedObjectSelector<? super K, ? super V> var1) throws Exception;

    @Managed
    @ManagedName(value="Size")
    @ManagedDescription(value="The cache size")
    public int getCacheSize();

    @Managed
    @ManagedName(value="MaxNodes")
    @ManagedDescription(value="Maximum number of entries in a cache instance. -1 means no limit.")
    public int getMaxSize();

    @Managed
    public void setMaxSize(int var1);

    @Managed
    @ManagedName(value="TimeToLive")
    @ManagedDescription(value="The maximum life time of an entry in seconds")
    public long getLiveTime();

    @Managed
    public void setLiveTime(long var1);

    @Managed
    @ManagedName(value="HitCount")
    @ManagedDescription(value="The count of cache hits")
    public int getCacheHit();

    @Managed
    @ManagedName(value="MissCount")
    @ManagedDescription(value="The count of cache misses")
    public int getCacheMiss();

    public List<? extends V> getCachedObjects() throws Exception;

    public List<? extends V> removeCachedObjects();

    public void addCacheListener(CacheListener<? super K, ? super V> var1) throws NullPointerException;

    default public void onGet(K key, V obj) {
    }

    default public void onExpire(K key, V obj) {
    }

    default public void onRemove(K key, V obj) {
    }

    default public void onPut(K key, V obj) {
    }

    default public void onPutLocal(K key, V obj) {
    }

    default public void onClearCache() {
    }

    public boolean isLogEnabled();

    public void setLogEnabled(boolean var1);
}

