/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.analytics.AnalyticsTrackEvent;
import liquibase.analytics.Event;
import liquibase.analytics.configuration.AnalyticsConfiguration;
import liquibase.analytics.configuration.AnalyticsConfigurationFactory;
import liquibase.analytics.configuration.LiquibaseRemoteAnalyticsConfiguration;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class AnalyticsBatch {
    private final List<AnalyticsTrackEvent> batch = new ArrayList<AnalyticsTrackEvent>();
    private final String writeKey;
    private final Map<String, ?> context;

    public static AnalyticsBatch fromLiquibaseEvent(Event event, String userId) throws Exception {
        AnalyticsConfigurationFactory analyticsConfigurationFactory = Scope.getCurrentScope().getSingleton(AnalyticsConfigurationFactory.class);
        AnalyticsConfiguration analyticsConfiguration = analyticsConfigurationFactory.getPlugin();
        String writeKey = null;
        if (analyticsConfiguration instanceof LiquibaseRemoteAnalyticsConfiguration) {
            writeKey = ((LiquibaseRemoteAnalyticsConfiguration)analyticsConfiguration).getWriteKey();
        }
        AnalyticsBatch analyticsBatch = new AnalyticsBatch(writeKey, null);
        AnalyticsBatch.addEventsToBatch(event, analyticsBatch, userId);
        return analyticsBatch;
    }

    private static void addEventsToBatch(Event event, AnalyticsBatch analyticsBatch, String userId) {
        List<Event> childEvents = event.getChildEvents();
        analyticsBatch.getBatch().add(AnalyticsTrackEvent.fromLiquibaseEvent(event, userId));
        if (CollectionUtils.isNotEmpty(childEvents)) {
            for (Event childEvent : childEvents) {
                AnalyticsBatch.addEventsToBatch(childEvent, analyticsBatch, userId);
            }
        }
    }

    @Generated
    public AnalyticsBatch(String writeKey, Map<String, ?> context) {
        this.writeKey = writeKey;
        this.context = context;
    }

    @Generated
    public List<AnalyticsTrackEvent> getBatch() {
        return this.batch;
    }

    @Generated
    public String getWriteKey() {
        return this.writeKey;
    }

    @Generated
    public Map<String, ?> getContext() {
        return this.context;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsBatch)) {
            return false;
        }
        AnalyticsBatch other = (AnalyticsBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AnalyticsTrackEvent> this$batch = this.getBatch();
        List<AnalyticsTrackEvent> other$batch = other.getBatch();
        if (this$batch == null ? other$batch != null : !((Object)this$batch).equals(other$batch)) {
            return false;
        }
        String this$writeKey = this.getWriteKey();
        String other$writeKey = other.getWriteKey();
        if (this$writeKey == null ? other$writeKey != null : !this$writeKey.equals(other$writeKey)) {
            return false;
        }
        Map<String, ?> this$context = this.getContext();
        Map<String, ?> other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsBatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AnalyticsTrackEvent> $batch = this.getBatch();
        result = result * 59 + ($batch == null ? 43 : ((Object)$batch).hashCode());
        String $writeKey = this.getWriteKey();
        result = result * 59 + ($writeKey == null ? 43 : $writeKey.hashCode());
        Map<String, ?> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnalyticsBatch(batch=" + this.getBatch() + ", writeKey=" + this.getWriteKey() + ", context=" + this.getContext() + ")";
    }
}

