/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.jmx.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.management.ObjectName;
import org.exoplatform.management.jmx.annotations.Property;

public class PropertyInfo {
    private final String key;
    private final Value value;

    public PropertyInfo(Class clazz, Property def) {
        Value value;
        String tmp = def.value();
        int length = tmp.length();
        if (length > 2 && tmp.charAt(0) == '{' && tmp.charAt(length - 1) == '}') {
            Method getter;
            String s = tmp.substring(1, length - 1);
            String getterName = "get" + s;
            try {
                getter = clazz.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Getter parameter for property " + s + " on class " + clazz.getName() + " does not exist", e);
            }
            if (getter.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Getter return type for property " + s + " on class " + clazz.getName() + " cannot be void");
            }
            if (getter.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Getter parameter type for property " + s + " on class " + clazz.getName() + " is not empty");
            }
            if (Modifier.isStatic(getter.getModifiers())) {
                throw new IllegalArgumentException("Getter for property " + s + " on class " + clazz.getName() + " is static");
            }
            value = new DynamicValue(getter);
        } else {
            value = new LitteralValue(tmp);
        }
        this.key = def.key();
        this.value = value;
    }

    public String resolveValue(Object instance) {
        return this.value.resolve(instance);
    }

    public String getKey() {
        return this.key;
    }

    private class DynamicValue
    extends Value {
        private final Method getter;

        private DynamicValue(Method getter) {
            this.getter = getter;
        }

        boolean hasSpecialChars(String valueString) {
            int length = valueString.length();
            for (int i = 0; i < length; ++i) {
                char c = valueString.charAt(i);
                switch (c) {
                    case '\"': 
                    case '%': 
                    case '\'': 
                    case '*': 
                    case ',': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '=': 
                    case '?': 
                    case '\\': {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        String resolve(Object instance) {
            Object value;
            try {
                value = this.getter.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Getter for property " + PropertyInfo.this.key + " on class " + this.getter.getClass().getName() + " cannot be invoked", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Getter for property " + PropertyInfo.this.key + " on class " + this.getter.getClass().getName() + " threw an exception during invocation", e);
            }
            if (value == null) {
                throw new IllegalArgumentException("Getter for property " + PropertyInfo.this.key + " on class " + this.getter.getClass().getName() + " returned a null value");
            }
            String valueString = value.toString();
            return this.hasSpecialChars(valueString) ? ObjectName.quote(valueString) : valueString;
        }
    }

    private static class LitteralValue
    extends Value {
        private final String litteral;

        private LitteralValue(String litteral) {
            this.litteral = litteral;
        }

        @Override
        String resolve(Object instance) {
            return this.litteral;
        }
    }

    private static abstract class Value {
        private Value() {
        }

        abstract String resolve(Object var1);
    }
}

