/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardsTotalStats
implements JsonpSerializable {
    private final long totalCount;
    public static final JsonpDeserializer<ShardsTotalStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsTotalStats::setupShardsTotalStatsDeserializer);

    private ShardsTotalStats(Builder builder) {
        this.totalCount = ApiTypeHelper.requireNonNull(builder.totalCount, (Object)this, "totalCount", 0L);
    }

    public static ShardsTotalStats of(Function<Builder, ObjectBuilder<ShardsTotalStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardsTotalStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalCount, JsonpDeserializer.longDeserializer(), "total_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsTotalStats> {
        private Long totalCount;

        public final Builder totalCount(long value) {
            this.totalCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsTotalStats build() {
            this._checkSingleUse();
            return new ShardsTotalStats(this);
        }
    }
}

