/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import jakarta.annotation.PostConstruct;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpacePermanentLinkPlugin
implements PermanentLinkPlugin {
    public static final String OBJECT_TYPE = "space";
    public static final String URI_HASH = "hash";
    public static final String APPLICATION_URI = "applicationUri";
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private PortalContainer portalContainer;

    @PostConstruct
    public void init() {
        ((PermanentLinkService)this.portalContainer.getComponentInstanceOfType(PermanentLinkService.class)).addPlugin((PermanentLinkPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
        if (identity == null || identity.getUserId() == null) {
            return false;
        }
        Space space = this.spaceService.getSpaceById(object.getObjectId());
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Space with id %s not found", object.getObjectId()));
        }
        String username = identity.getUserId();
        return this.spaceService.isSuperManager(space, username) || this.spaceService.isInvitedUser(space, username) || this.spaceService.isMember(space, username) || !StringUtils.equals((CharSequence)"hidden", (CharSequence)space.getVisibility()) && !StringUtils.equals((CharSequence)"closed", (CharSequence)space.getRegistration());
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        String spaceId = object.getObjectId();
        Space space = StringUtils.isNumeric((CharSequence)spaceId) ? this.spaceService.getSpaceById(spaceId) : this.spaceService.getSpaceByPrettyName(spaceId);
        StringBuilder spaceUrl = new StringBuilder("/portal/g/");
        spaceUrl.append(Arrays.stream(space.getGroupId().split("/")).map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8)).collect(Collectors.joining(":"))).append("/");
        if (space.getUrl() != null) {
            spaceUrl.append(URLEncoder.encode(space.getUrl(), StandardCharsets.UTF_8)).append("/");
        }
        if (object.getParameters() != null) {
            if (object.getParameters().containsKey(APPLICATION_URI)) {
                spaceUrl.append((String)object.getParameters().get(APPLICATION_URI));
            }
            if (object.getParameters().containsKey(URI_HASH)) {
                spaceUrl.append("#").append((String)object.getParameters().get(URI_HASH));
            }
        }
        return spaceUrl.toString();
    }
}

