/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.navigation.plugin.AbstractSpaceSidebarPlugin;
import io.meeds.social.navigation.plugin.SidebarPluginUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.core.space.SpaceFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=40)
public class SpaceListSidebarPlugin
extends AbstractSpaceSidebarPlugin {
    public static final String SPACES_NAMES = "names";
    private static final String SPACE_CATEGORY_IDS = "spaceCategoryIds";
    private static final String SPACE_TEMPLATE_IDS = "spaceTemplateIds";
    private static final String EXCLUDED_CATEGORY_IDS = "excludedCategoryIds";
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final PageKey SPACES_PAGE_KEY = new PageKey(SiteKey.portal((String)"global"), "all-spaces");
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private UserPortalConfigService portalConfigService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private CategoryService categoryService;

    public SidebarItemType getType() {
        return SidebarItemType.SPACES;
    }

    public boolean itemExists(SidebarItem item, String username) {
        if (item == null || item.getProperties() == null) {
            return false;
        }
        return item.getProperties().containsKey(SPACES_NAMES);
    }

    public SidebarItem resolveProperties(SidebarItem item, String username, Locale locale) {
        item.setName(SidebarPluginUtils.getNameFromProperties(this.localeConfigService, item, SPACES_NAMES, locale));
        item.setItems(this.getSpaces(item, username));
        if (this.hasAccessToSpacesPage(username)) {
            item.setUrl(String.format("/portal/%s/spaces", this.portalConfigService.getMetaPortal()));
        } else {
            item.setUrl(null);
        }
        item.setDefaultPath(false);
        return item;
    }

    public List<SidebarItem> getDefaultItems() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(SPACES_NAMES, "{\"en\": \"sidebar.viewAllSpaces\"}");
        properties.put("limit", "0");
        properties.put("sortBy", "TITLE");
        return Collections.singletonList(new SidebarItem(null, null, null, null, "fa-layer-group", SidebarItemType.SPACES, null, properties, true));
    }

    @Override
    protected void buildSpaceFilter(String username, SidebarItem item, SpaceFilter spaceFilter) {
        List<Long> excludedCategoryIds = SpaceListSidebarPlugin.getLongListFromJson(item.getProperties(), EXCLUDED_CATEGORY_IDS);
        List<Long> categoryIds = SpaceListSidebarPlugin.getLongListFromJson(item.getProperties(), SPACE_CATEGORY_IDS);
        List<Long> templateIds = SpaceListSidebarPlugin.getLongListFromJson(item.getProperties(), SPACE_TEMPLATE_IDS);
        if (excludedCategoryIds != null) {
            HashSet<Long> allExcluded = new HashSet<Long>(excludedCategoryIds);
            for (Long parentId : excludedCategoryIds) {
                List subCategoryIds = this.categoryService.getSubcategoryIds(username, parentId.longValue(), 0L, -1L, -1L);
                if (subCategoryIds == null) continue;
                allExcluded.addAll(subCategoryIds);
            }
            spaceFilter.setExcludedCategoryIds(new ArrayList<Long>(allExcluded));
        }
        if (categoryIds != null) {
            spaceFilter.setCategoryIds(categoryIds);
        }
        if (templateIds != null) {
            spaceFilter.setTemplateIds(templateIds);
        }
    }

    private boolean hasAccessToSpacesPage(String username) {
        Page spacesPage = this.layoutService.getPage(SPACES_PAGE_KEY);
        return spacesPage != null && this.userAcl.hasAccessPermission(spacesPage, this.userAcl.getUserIdentity(username));
    }

    private static List<Long> getLongListFromJson(Map<String, String> properties, String key) {
        String value = properties.get(key);
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            List list = (List)mapper.readValue(value, (TypeReference)new TypeReference<List<Long>>(){});
            return list.isEmpty() ? null : list;
        }
        catch (Exception e) {
            return null;
        }
    }
}

