/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JavaTimeJdbcType;

public class GetObjectExtractor<T>
extends BasicExtractor<T> {
    private final Class<?> baseClass;

    public GetObjectExtractor(JavaType<T> javaType, JavaTimeJdbcType jdbcType, Class<?> baseClass) {
        super(javaType, jdbcType);
        this.baseClass = baseClass;
    }

    @Override
    protected T doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
        return (T)this.getJavaType().wrap(rs.getObject(paramIndex, this.baseClass), options);
    }

    @Override
    protected T doExtract(CallableStatement statement, int paramIndex, WrapperOptions options) throws SQLException {
        return (T)this.getJavaType().wrap(statement.getObject(paramIndex, this.baseClass), options);
    }

    @Override
    protected T doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
        return (T)this.getJavaType().wrap(statement.getObject(name, this.baseClass), options);
    }
}

