/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;

class MultiBufferEntity
extends AbstractHttpEntity
implements HttpAsyncContentProducer {
    private final Iterable<ByteBuffer> buffers;
    private Iterator<ByteBuffer> iterator;
    private volatile ByteBuffer currentBuffer;

    MultiBufferEntity(Iterable<ByteBuffer> buffers, ContentType contentType) {
        this.buffers = buffers;
        this.setChunked(true);
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
        this.init();
    }

    public void close() throws IOException {
        this.init();
    }

    private void init() {
        Iterator<ByteBuffer> localIterator = this.buffers.iterator();
        this.currentBuffer = localIterator.hasNext() ? localIterator.next().duplicate() : null;
        this.iterator = localIterator;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        NoCopyByteArrayOutputStream baos = new NoCopyByteArrayOutputStream();
        this.writeTo(baos);
        return baos.asInputStream();
    }

    public void writeTo(OutputStream out) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        for (ByteBuffer buffer : this.buffers) {
            channel.write(buffer.duplicate());
        }
    }

    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        if (this.currentBuffer == null) {
            encoder.complete();
            return;
        }
        encoder.write(this.currentBuffer);
        if (!this.currentBuffer.hasRemaining()) {
            if (this.iterator.hasNext()) {
                this.currentBuffer = this.iterator.next().duplicate();
            } else {
                this.currentBuffer = null;
                encoder.complete();
            }
        }
    }
}

